/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.index;

import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunEntry;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

@Index(name="github-check-runs", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED, EStorageOption.BACKUP}, valueClasses={GitHubCheckRunEntry.class})
public class GitHubCheckRunIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "github-check-runs";
    private static final String DELIMITER = "#";
    private final ValueIndex<ArrayList<GitHubCheckRunEntry>> delegate;

    public GitHubCheckRunIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storeId(String revision, PlatformRepositoryIdentifier repositoryIdentifier, CommitDescriptor commit, ECheckRunType type, Long checkRunId) throws StorageException {
        GitHubCheckRunEntry newEntry = new GitHubCheckRunEntry(commit, checkRunId, type);
        String key = GitHubCheckRunIndex.createKey(repositoryIdentifier, revision);
        ArrayList<GitHubCheckRunEntry> entriesToKeep = new ArrayList<GitHubCheckRunEntry>(this.getEntriesToKeep(key, type));
        entriesToKeep.add(newEntry);
        this.delegate.setValue(key, entriesToKeep);
    }

    public Optional<Long> readId(String revision, PlatformRepositoryIdentifier repositoryIdentifier, ECheckRunType type) throws StorageException {
        List entries = (List)this.delegate.getValue(GitHubCheckRunIndex.createKey(repositoryIdentifier, revision));
        if (entries == null) {
            return Optional.empty();
        }
        return entries.stream().filter(entry -> entry.getCheckRunType() == type).map(GitHubCheckRunEntry::getCheckRunId).findFirst();
    }

    public void removeAllCheckRunsForRevision(String revision, PlatformRepositoryIdentifier repositoryIdentifier) throws StorageException {
        this.delegate.removeValue(GitHubCheckRunIndex.createKey(repositoryIdentifier, revision));
    }

    public void removeCheckRun(String revision, PlatformRepositoryIdentifier repositoryIdentifier, ECheckRunType type) throws StorageException {
        String key = GitHubCheckRunIndex.createKey(repositoryIdentifier, revision);
        ArrayList<GitHubCheckRunEntry> entriesToKeep = this.getEntriesToKeep(key, type);
        if (entriesToKeep.isEmpty()) {
            this.delegate.removeValue(key);
        } else {
            this.delegate.setValue(key, entriesToKeep);
        }
    }

    private ArrayList<GitHubCheckRunEntry> getEntriesToKeep(String key, ECheckRunType type) throws StorageException {
        ArrayList entriesToKeep = (ArrayList)this.delegate.getValue(key);
        if (entriesToKeep == null) {
            return new ArrayList<GitHubCheckRunEntry>();
        }
        entriesToKeep.removeIf(entry -> entry.getCheckRunType() == type);
        return entriesToKeep;
    }

    public List<GitHubCheckRunInfo> readAll() throws StorageException {
        return this.delegate.getAllEntries().stream().flatMap(GitHubCheckRunIndex::augmentEntryWithRevisionAndRepository).toList();
    }

    private static Stream<GitHubCheckRunInfo> augmentEntryWithRevisionAndRepository(Pair<String, ArrayList<GitHubCheckRunEntry>> keyAndEntry) {
        return ((ArrayList)keyAndEntry.getSecond()).stream().map(entry -> GitHubCheckRunIndex.createGitHubCheckRunInfo((String)keyAndEntry.getFirst(), entry));
    }

    public List<GitHubCheckRunInfo> readEntriesForBranch(String branchName) throws StorageException {
        return this.readAll().stream().filter(entry -> entry.getCommit().getBranchName().equals(branchName)).collect(Collectors.toList());
    }

    public List<GitHubCheckRunInfo> readEntriesForRevision(String revision, PlatformRepositoryIdentifier repositoryIdentifier) throws StorageException {
        String key = GitHubCheckRunIndex.createKey(repositoryIdentifier, revision);
        ArrayList entries = (ArrayList)this.delegate.getValue(key);
        if (entries == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map((Collection)entries, entry -> GitHubCheckRunIndex.createGitHubCheckRunInfo(key, entry));
    }

    private static String createKey(PlatformRepositoryIdentifier repositoryIdentifier, String revision) {
        return repositoryIdentifier.asNormalizedRepositoryPath() + DELIMITER + revision;
    }

    private static GitHubCheckRunInfo createGitHubCheckRunInfo(String key, GitHubCheckRunEntry entry) {
        String[] repositoryAndRevision = key.split(DELIMITER);
        CCSMAssert.isTrue((repositoryAndRevision.length == 2 ? 1 : 0) != 0, (String)("Invalid key: '" + key + "'. Must consist of the repository name and the revision separated by '#'."));
        String repository = repositoryAndRevision[0];
        String revision = repositoryAndRevision[1];
        return new GitHubCheckRunInfo(revision, PlatformRepositoryIdentifier.fromRepositoryPath(repository), entry);
    }

    public void clear() throws StorageException {
        this.delegate.removeAllEntries();
    }
}

