/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.merge_request_fetch_strategy;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.GitHubDataFetchConfiguration;
import com.teamscale.index.repository.git.github.merge_request_fetch_strategy.IGitHubMergeRequestDataFetchStrategy;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NonNull;

public class GitHubApiFetchStrategy
implements IGitHubMergeRequestDataFetchStrategy {
    private final GitHubDataFetchConfiguration dataFetchConfiguration;
    private static final Logger LOGGER = LogManager.getLogger();

    public GitHubApiFetchStrategy(GitHubDataFetchConfiguration dataFetchConfiguration) {
        this.dataFetchConfiguration = dataFetchConfiguration;
    }

    @Override
    public @NonNull GitHubPullRequest getPlatformMergeRequest(PlatformRepositoryIdentifier repositoryIdentifier, long id) throws ServiceCallException {
        GitHubPullRequest pullRequest = this.dataFetchConfiguration.client().getPullRequest(repositoryIdentifier, (int)id);
        if (!this.dataFetchConfiguration.shouldWriteIntoPayloadIndex()) {
            return pullRequest;
        }
        try {
            this.dataFetchConfiguration.webhookPayloadIndex().addPullRequestFromPayload(new MergeRequestIdentifier(repositoryIdentifier.asRepositoryPath(), (long)pullRequest.number()), pullRequest);
        }
        catch (StorageException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to store pull request '{}' in the webhook payload index.", (Object)pullRequest.number());
        }
        return pullRequest;
    }

    public List<CheckRun> getCheckRuns(PlatformRepositoryIdentifier repositoryIdentifier, String mergeRequestSourceHead) throws ServiceCallException {
        return this.fetchAndWriteInPayloadIndexIfNeeded(() -> this.dataFetchConfiguration.client().getCheckRuns(repositoryIdentifier, mergeRequestSourceHead), checkRuns -> this.dataFetchConfiguration.webhookPayloadIndex().addCheckRunsFromPayload(mergeRequestSourceHead, (List<CheckRun>)checkRuns), "Failed to store check runs for commit: '{}' in the webhook payload index.", mergeRequestSourceHead);
    }

    public List<GitHubCommitStatus> getCommitStatuses(PlatformRepositoryIdentifier repositoryIdentifier, String mergeRequestSourceHead) throws ServiceCallException {
        return this.fetchAndWriteInPayloadIndexIfNeeded(() -> this.dataFetchConfiguration.client().getCommitStatuses(repositoryIdentifier, mergeRequestSourceHead), commitStatuses -> this.dataFetchConfiguration.webhookPayloadIndex().addCommitStatusesFromPayload(mergeRequestSourceHead, (List<GitHubCommitStatus>)commitStatuses), "Failed to store GitHub commit statuses for commit '{}' in the webhook payload index.", mergeRequestSourceHead);
    }

    @Override
    public List<GitHubPullRequest> getAllOpenPlatformMergeRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        List<GitHubPullRequest> openPullRequests = this.dataFetchConfiguration.client().getOpenPullRequests(repositoryIdentifier);
        if (!this.dataFetchConfiguration.shouldWriteIntoPayloadIndex() || openPullRequests.isEmpty()) {
            return openPullRequests;
        }
        try {
            this.dataFetchConfiguration.webhookPayloadIndex().addPullRequestsFromPayload(repositoryIdentifier.asRepositoryPath(), openPullRequests);
        }
        catch (StorageException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to store pull requests '{}' in the webhook payload index.", (Object)String.join((CharSequence)",", CollectionUtils.map(openPullRequests, pr -> String.valueOf(pr.number()))));
        }
        return openPullRequests;
    }

    private <T> List<T> fetchAndWriteInPayloadIndexIfNeeded(SupplierWithException<List<T>, ServiceCallException> dataFetcher, ConsumerWithException<List<T>, StorageException> indexWriter, String logMessageFormat, String headCommitSha) throws ServiceCallException {
        List fetchedItems = (List)dataFetcher.get();
        if (!this.dataFetchConfiguration.shouldWriteIntoPayloadIndex() || fetchedItems.isEmpty()) {
            return fetchedItems;
        }
        try {
            indexWriter.accept((Object)fetchedItems);
        }
        catch (StorageException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log(logMessageFormat, (Object)headCommitSha);
        }
        return fetchedItems;
    }
}

