/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.WebHookBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.gitlab.GitLabChangeRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.GitLabContentUpdater;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestSynchronizer;
import com.teamscale.index.repository.git.gitlab.data.EAccessLevel;
import com.teamscale.index.repository.git.gitlab.data.GitLabHook;
import com.teamscale.index.repository.git.gitlab.data.GitLabProject;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@ConnectorDescriptor
public class GitLabRepositoryConnectorDescriptor
extends WebHookBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String LEGACY_GITLAB_HOOK_END_POINT = "gitlab-hook";
    public static final String GITLAB_HOOK_END_POINT = "api/gitlab/web-hook";
    static final String GITLAB_TOKEN_USER_NAME = "gitlab-ci-token";
    @ConfigExposed(name="Badges for Metrics", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, changeRequiresReAnalysis=false, description="Metrics which should be tracked in merge requests via badges.")
    protected MetricBadgesConfiguration metricThresholdBadges = new MetricBadgesConfiguration();
    @ConfigExposed(name="Badges for Metric Groups", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL, changeRequiresReAnalysis=false, description="Metrics which should be included in a summarized badge for their group in merge requests.")
    protected MetricBadgesConfiguration metricThresholdGroupBadges = new MetricBadgesConfiguration();

    public GitLabRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.GITLAB, LOGGER);
        this.defaultBranchName = "main";
        this.hideOption("Enable Voting for Findings");
        if (!EFeatureToggle.ENABLE_GITLAB_METRIC_BADGES.isEnabled()) {
            this.hideOption("Badges for Metrics");
            this.hideOption("Badges for Metric Groups");
        }
        this.autoExpose();
    }

    private GitLabClient getClient() throws ConnectorValidationException {
        ExternalCredentials credentials = this.resolveExternalCredentials();
        return new GitLabClient(super.getRepositoryUri().toString(), credentials.password, LOGGER);
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return GitLabRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), this.repositoryPath, "commit/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() throws ConnectorValidationException {
        return GitLabRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(super.getRepositoryUri().toString(), this.repositoryPath, "merge_requests/{mergeRequestId}/diffs?commit_id={commitId}");
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        try {
            return GitLabRepositoryConnectorDescriptor.resolveProjectUri(this.getClient().getProject(this.getRepositoryPath()), super.getRepositoryUri(), this.getPrivateKeyId());
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException("Could not acquire repository URL for repository " + this.getRepositoryPath(), (Throwable)e);
        }
    }

    @Override
    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        ExternalCredentials credentials = super.resolveExternalCredentials();
        return new ExternalCredentials(credentials.credentialsName, credentials.uri, GITLAB_TOKEN_USER_NAME, credentials.password);
    }

    @VisibleForTesting
    static URI resolveProjectUri(GitLabProject project, URI serverUri, @Nullable String sshKeyId) {
        URI projectUri = project.getHttpUriToRepo();
        if (!StringUtils.isEmpty((String)sshKeyId)) {
            projectUri = URI.create(GitUtils.rewriteGitAtUrl(project.getSshUriToRepo()));
        }
        if (serverUri.getHost().equals("localhost") && !projectUri.toString().startsWith(serverUri.toString()) && projectUri.getScheme().equals("http")) {
            projectUri = UriBuilder.fromUri((URI)projectUri).host("localhost").build(new Object[0]);
        }
        return projectUri;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        if (!this.disableAutomaticWebhookCreation) {
            try {
                if (this.getClient().getProjectAccessLevel(this.getRepositoryPath()).compareTo(EAccessLevel.MAINTAINER) < 0) {
                    throw new ConnectorValidationException("The configured GitLab user must have at least 'Maintainer' access level on this repository to configure the web hooks.\nYou can either:\n- Grant the configured GitLab user the required permissions.\n- Proceed now by selecting the 'Disable automatic webhook creation' expert option and setting up webhooks manually later.\nSee our documentation for instructions.");
                }
            }
            catch (ServiceCallException e) {
                throw new ConnectorValidationException("Could not check project access level: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void ensureHookIsConfigured(ServerOptionIndex serverOptionIndex) throws StorageException, ServiceCallException, ConnectorValidationException {
        String legacyUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + LEGACY_GITLAB_HOOK_END_POINT;
        GitLabClient client = this.getClient();
        List<GitLabHook> hooks = client.listProjectHooks(this.getRepositoryPath());
        Optional<GitLabHook> legacyMatchingHook = hooks.stream().filter(hook -> legacyUrl.equals(hook.getUrl()) && hook.signalsPushEvents() && hook.signalsMergeRequestEvents()).findFirst();
        String expectedUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)serverOptionIndex) + GITLAB_HOOK_END_POINT;
        if (legacyMatchingHook.isPresent()) {
            client.updateProjectHook(legacyMatchingHook.get().getId(), this.getRepositoryPath(), expectedUrl);
            return;
        }
        Optional<GitLabHook> matchingHook = hooks.stream().filter(hook -> expectedUrl.equals(hook.getUrl()) && hook.signalsPushEvents() && hook.signalsMergeRequestEvents()).findFirst();
        if (matchingHook.isPresent()) {
            GitLabHook hook2 = matchingHook.get();
            if (!hook2.signalsBuildJobEvents()) {
                client.updateProjectHook(hook2.getId(), this.getRepositoryPath(), expectedUrl);
            }
            return;
        }
        client.createProjectHook(this.getRepositoryPath(), expectedUrl);
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return GitLabContentUpdater.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return GitLabChangeRetriever.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return GitLabMergeRequestSynchronizer.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return GitLabMergeRequestAnnotationTrigger.class;
    }

    @Override
    protected boolean requiresBuildCompleteness() {
        return true;
    }

    @Override
    protected boolean supportsCloningViaSsh() {
        return true;
    }
}

