/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiscussion;
import com.teamscale.index.repository.git.gitlab.data.GitLabMergeRequest;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class GitLabUtils {
    private static final Pattern CHANGE_HUNK_HEADER_PATTERN = Pattern.compile("@@ -(\\d*),\\d* \\+(\\d*),\\d* @@.*");
    public static final String MAIN_BRANCH = "main";

    static List<IReviewComment> filterCommentsNotInMergeRequest(List<IReviewComment> comments, GitLabMergeRequest mergeRequest) {
        Set<String> pathsInMergeRequest = mergeRequest.getPaths();
        return CollectionUtils.filter(comments, comment -> pathsInMergeRequest.contains(comment.getLocation().getUniformPath()));
    }

    public static TreeMap<Integer, Integer> buildParallelLineMap(String diff) {
        String[] lines;
        TreeMap<Integer, Integer> newToOldLineMap = new TreeMap<Integer, Integer>();
        int newLine = 0;
        int oldLine = 0;
        for (String line : lines = StringUtils.normalizeLineSeparatorsPlatformIndependent((String)diff).split("\n")) {
            Matcher matcher;
            if (line.startsWith("@@") && (matcher = CHANGE_HUNK_HEADER_PATTERN.matcher(line)).matches()) {
                int oldBlockStart = Integer.parseInt(matcher.group(1)) - 1;
                int newBlockStart = Integer.parseInt(matcher.group(2)) - 1;
                while (oldLine < oldBlockStart && newLine < newBlockStart) {
                    newToOldLineMap.put(++newLine, ++oldLine);
                }
                while (newLine < newBlockStart) {
                    newToOldLineMap.put(++newLine, oldLine);
                }
                assert (newLine == newBlockStart);
                continue;
            }
            if (line.startsWith("+")) {
                newToOldLineMap.put(++newLine, null);
                continue;
            }
            if (line.startsWith("-")) {
                ++oldLine;
                continue;
            }
            newToOldLineMap.put(++newLine, ++oldLine);
        }
        return newToOldLineMap;
    }

    private GitLabUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static class MergeRequestSpecificGitLabClient {
        private final GitLabClient client;
        private final String repository;
        private final long mergeRequestId;

        MergeRequestSpecificGitLabClient(GitLabClient client, String repository, long mergeRequestId) {
            this.client = client;
            this.repository = repository;
            this.mergeRequestId = mergeRequestId;
        }

        GitLabMergeRequest getMergeRequestWithChanges() throws ServiceCallException {
            return this.client.getMergeRequestWithChanges(this.repository, this.mergeRequestId);
        }

        List<GitLabDiscussion> listOpenOrResolvedMergeRequestDiscussions() throws ServiceCallException {
            return this.client.listOpenOrResolvedMergeRequestDiscussions(this.repository, this.mergeRequestId);
        }

        void createMergeRequestDiscussion(GitLabNote note) throws ServiceCallException, UnsupportedEncodingException {
            this.client.createMergeRequestDiscussion(this.repository, this.mergeRequestId, note);
        }

        void resolveMergeRequestDiscussion(GitLabDiscussion discussion) throws ServiceCallException {
            this.client.resolveMergeRequestDiscussion(this.repository, this.mergeRequestId, discussion.getId(), true);
        }

        void updateMergeRequestDiscussion(GitLabDiscussion discussion, String newBody) throws ServiceCallException {
            this.client.updateMergeRequestDiscussion(this.repository, this.mergeRequestId, discussion.getId(), discussion.getFirstNoteId(), newBody);
        }

        void replyToMergeRequestDiscussion(GitLabDiscussion discussion, String message) throws ServiceCallException {
            this.client.replyToMergeRequestDiscussion(this.repository, this.mergeRequestId, discussion.getId(), message);
        }

        void deleteMergeRequestNote(long noteId) throws ServiceCallException {
            this.client.deleteMergeRequestNote(this.repository, this.mergeRequestId, noteId);
        }
    }
}

