/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.mock_connector;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.base.IncludeExcludeStepParameter;
import com.teamscale.index.repository.git.GitChangeRetriever;
import com.teamscale.index.repository.git.mock_connector.ArtificialMergeRequestProvider;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep
public class ArtificialMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<ArtificialMergeRequestProvider, MergeRequest> {
    @StepParameter(value="repository-uri")
    private String repositoryUri;
    @StepParameter(value="merge-request-branches")
    private PairList<String, String> branchesForMergeRequestsInput;
    @StepParameter(value="Repository Path")
    private String repositoryPath;
    @StepParameter(value="Build jobs for artificial merge requests")
    private List<String> buildJobsForMergeRequestsInput;
    @StepParameterObject(namePrefix="build-")
    private final IncludeExcludeStepParameter<IncludeExcludeRegexSupport> buildPatternSupport = new IncludeExcludeStepParameter<IncludeExcludeRegexSupport>(IncludeExcludeRegexSupport::new);

    @Override
    protected ArtificialMergeRequestProvider createMergeRequestProvider() throws StorageException, ServiceCallException {
        try {
            return new ArtificialMergeRequestProvider(this.repositoryPath, this.repositoryUri, this.branchesForMergeRequestsInput, this.buildJobsForMergeRequestsInput, this.buildPatternSupport.get());
        }
        catch (IOException | URISyntaxException | RepositoryException e) {
            throw new StorageException(e);
        }
    }

    @Override
    protected String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return GitChangeRetriever.class;
    }
}

