/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.retrievers;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryBranchRetriever;
import com.teamscale.index.repository.artifact_store.s3.S3BranchRetriever;
import com.teamscale.index.repository.filesystem.multiversion.MultiVersionFileSystemBranchRetriever;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitBranchRetriever;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudDataRetriever;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerBranchRetriever;
import com.teamscale.index.repository.git.gerrit.GerritBranchRetriever;
import com.teamscale.index.repository.git.gitea.GiteaBranchRetriever;
import com.teamscale.index.repository.git.github.GitHubDataRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabBranchRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerBranchRetriever;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapBranchRetriever;
import com.teamscale.index.repository.svn.SVNBranchRetriever;
import com.teamscale.index.repository.tfs.TfsBranchRetriever;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class BranchesRetrieverFactory {
    public static IBranchRetriever getBranchRetriever(ConnectorConfiguration connectorConfiguration, ERepositoryConnector repositoryConnector, GlobalStorageSystem storageSystem, Logger interactionLogger) throws StorageException {
        String pathSuffix = connectorConfiguration.getOptionValue("Path suffix");
        IBranchRetriever branchRetriever = BranchesRetrieverFactory.getGitBasedBranchRetriever(repositoryConnector, pathSuffix, storageSystem, interactionLogger);
        if (branchRetriever != null) {
            return branchRetriever;
        }
        return switch (repositoryConnector) {
            case ERepositoryConnector.ARTIFACTORY -> new ArtifactoryBranchRetriever(interactionLogger);
            case ERepositoryConnector.MULTI_VERSION_FILE_SYSTEM -> new MultiVersionFileSystemBranchRetriever();
            case ERepositoryConnector.S3 -> new S3BranchRetriever();
            case ERepositoryConnector.SVN -> new SVNBranchRetriever();
            case ERepositoryConnector.TFS -> new TfsBranchRetriever();
            default -> null;
        };
    }

    private static IBranchRetriever getGitBasedBranchRetriever(ERepositoryConnector repositoryConnector, String pathSuffix, GlobalStorageSystem storageSystem, Logger interactionLogger) throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)storageSystem.openGlobalIndex(ServerOptionIndex.class);
        return switch (repositoryConnector) {
            case ERepositoryConnector.ABAP_GIT -> new AbapBranchRetriever(serverOptionIndex);
            case ERepositoryConnector.AZURE_DEVOPS_GIT -> new AzureDevOpsGitBranchRetriever(serverOptionIndex, interactionLogger);
            case ERepositoryConnector.BITBUCKET -> new BitbucketCloudDataRetriever(storageSystem, interactionLogger);
            case ERepositoryConnector.BITBUCKET_SERVER -> new BitbucketServerBranchRetriever(interactionLogger);
            case ERepositoryConnector.GERRIT -> new GerritBranchRetriever(serverOptionIndex, pathSuffix);
            case ERepositoryConnector.GIT -> new GitBranchRetriever(serverOptionIndex, pathSuffix);
            case ERepositoryConnector.GITHUB -> new GitHubDataRetriever(storageSystem, interactionLogger);
            case ERepositoryConnector.GITLAB -> new GitLabBranchRetriever(interactionLogger);
            case ERepositoryConnector.SCM_MANAGER -> new ScmManagerBranchRetriever(interactionLogger);
            case ERepositoryConnector.GITEA -> new GiteaBranchRetriever(interactionLogger);
            default -> null;
        };
    }
}

