/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.importer.SapVersion;
import com.teamscale.index.repository.sap.abapsystem.importer.SapVersionIndex;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapChangeRetriever;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public final class AbapProjectUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern CONFIGURATION_ID_PATTERN = Pattern.compile("^.*/sap.abap.system/(.*?)/git");
    public static final String DEFAULT_ABAPLINT_ANALYSIS_VERSION = "v740sp08";
    @VisibleForTesting
    public static final Pattern IS_LIKELY_SAP_SYSTEM_ID_PATTERN = Pattern.compile("^[A-Z][A-Z0-9]{2}$");

    public static Map<String, IncludeExcludeAntPatternSupport> resolveSapConfigurationIdsWithNamespacesForProject(ExternalCredentialsIndex externalCredentialsIndex, MetaIndex metaIndex) throws StorageException {
        ProjectConfiguration projectConfig = ProjectConfigurationUtils.getProjectConfiguration((MetaIndex)metaIndex);
        HashMap<String, IncludeExcludeAntPatternSupport> configurationIdsWithNamespaces = new HashMap<String, IncludeExcludeAntPatternSupport>();
        for (ConnectorConfiguration connector : projectConfig.getConnectors()) {
            Optional<String> configurationId = AbapProjectUtils.parseSapConfigurationId(connector, externalCredentialsIndex);
            if (configurationId.isEmpty() || StringUtils.isEmpty((String)configurationId.get())) continue;
            IncludeExcludeAntPatternSupport includesAndExcludes = new IncludeExcludeAntPatternSupport(false, AbapProjectUtils.parseAbapNamespace(connector.getOptionValue("Included file names")), AbapProjectUtils.parseAbapNamespace(connector.getOptionValue("Excluded file names")));
            configurationIdsWithNamespaces.put(configurationId.get(), includesAndExcludes);
        }
        return configurationIdsWithNamespaces;
    }

    public static Set<String> resolveSapConfigurationIdsForProject(ExternalCredentialsIndex externalCredentialsIndex, MetaIndex metaIndex) throws StorageException {
        HashSet<String> sapConfigIds = new HashSet<String>();
        ProjectConfiguration projectConfig = ProjectConfigurationUtils.getProjectConfiguration((MetaIndex)metaIndex);
        for (ConnectorConfiguration connector : projectConfig.getConnectors()) {
            Optional<String> configurationId = AbapProjectUtils.parseSapConfigurationId(connector, externalCredentialsIndex);
            if (!configurationId.isPresent() || StringUtils.isEmpty((String)configurationId.get())) continue;
            sapConfigIds.add(configurationId.get());
        }
        return sapConfigIds;
    }

    private static Optional<String> parseSapConfigurationId(ConnectorConfiguration connectorConfiguration, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException {
        if (connectorConfiguration.isRepositoryType(ERepositoryConnector.ABAP_GIT)) {
            return Optional.ofNullable(connectorConfiguration.getOptionValue("SAP connection"));
        }
        if (connectorConfiguration.isRepositoryType(ERepositoryConnector.GIT)) {
            String accountIdentifier = connectorConfiguration.getOptionValue("Account");
            Optional<ExternalCredentials> externalCredentials = Optional.ofNullable(externalCredentialsIndex.getExternalCredentials(accountIdentifier));
            if (externalCredentials.isEmpty()) {
                throw new InternalServerErrorException("No external accounts " + accountIdentifier + " found.");
            }
            String pathSuffix = connectorConfiguration.getOptionValue("Path suffix");
            String uri = UniformPathUtils.normalizeAllSeparators((String)(StringUtils.ensureEndsWith((String)externalCredentials.get().uri, (String)"/") + pathSuffix));
            Matcher matcher = CONFIGURATION_ID_PATTERN.matcher(uri);
            if (matcher.find()) {
                return Optional.ofNullable(matcher.group(1));
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static List<String> parseAbapNamespace(String filesPattern) {
        if (StringUtils.isEmpty((String)filesPattern)) {
            return CollectionUtils.emptyList();
        }
        String[] filePatterns = filesPattern.split("[,\\r\\n]");
        Predicate<String> isAbapFilePattern = pattern -> !pattern.startsWith("#") && (pattern.endsWith("*.abap") || pattern.endsWith("**"));
        Function<String, String> parseNamespace = pattern -> pattern.substring(0, pattern.indexOf(42)).replace('!', '/').replaceAll("\\/+", "/");
        return Arrays.stream(filePatterns).map(String::trim).map(String::toLowerCase).map(pattern -> StringUtils.stripPrefix((String)pattern, (String)"**/")).filter(isAbapFilePattern).map(parseNamespace).map(String::toUpperCase).filter(namespace -> !namespace.isEmpty()).distinct().collect(Collectors.toList());
    }

    public static List<PublicProjectId> getProjects(String sapSystemId, IndexLayer indexLayer, ServicePermissions permissions) throws StorageException {
        ArrayList<PublicProjectId> projects = new ArrayList<PublicProjectId>();
        for (ProjectInfo project : permissions.getVisibleProjects()) {
            String sapSystemIdFromProject = AbapProjectUtils.getSapSystemIdFromConnector(project, indexLayer).orElse(null);
            if (!Objects.equals(sapSystemIdFromProject, sapSystemId)) continue;
            projects.add(project.getPrimaryPublicId());
        }
        Collections.sort(projects);
        return projects;
    }

    public static Optional<String> getSapSystemIdFromConnector(ProjectInfo projectInfo, IndexLayer indexLayer) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((ProjectInfo)projectInfo, (IndexLayer)indexLayer);
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class);
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            String configurationId = AbapProjectUtils.parseSapConfigurationId(connectorConfiguration, externalCredentialsIndex).orElse(null);
            if (configurationId == null) continue;
            Optional<String> sapSystemId = AbapProjectUtils.getSapSystemIdFromGlobalSapSettings(configurationId, serverOptionIndex);
            if (sapSystemId.isEmpty() && IS_LIKELY_SAP_SYSTEM_ID_PATTERN.matcher(configurationId).matches()) {
                sapSystemId = Optional.of(configurationId);
            }
            return sapSystemId;
        }
        return Optional.empty();
    }

    private static Optional<String> getSapSystemIdFromGlobalSapSettings(String configurationId, ServerOptionIndex serverOptionIndex) throws StorageException {
        AbapSystemDescription sapServerOption = AbapProjectUtils.getAbapSystemDescriptionFromGlobalSettings(configurationId, serverOptionIndex);
        if (!sapServerOption.jcoR3Name.isEmpty()) {
            return Optional.of(sapServerOption.jcoR3Name);
        }
        return Optional.empty();
    }

    public static @Nullable AbapSystemDescription getAbapSystemDescriptionFromGlobalSettings(String configurationId, ServerOptionIndex serverOptionIndex) throws StorageException {
        return (AbapSystemDescription)ServerOptionRegistry.getInstance().getOption("server", "sap.abap.system", configurationId, AbapSystemDescription.class, (OptionIndexBase)serverOptionIndex);
    }

    public static boolean updateProjects(String sapConnectionIdentifier, IndexLayer indexLayer) throws StorageException {
        boolean isAnyProjectUpdated = false;
        ProjectIndex projectIndex = (ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            ProjectConfiguration projectConfig = ProjectUtils.retrieveProjectConfig((ProjectInfo)projectInfo, (IndexLayer)indexLayer);
            for (ConnectorConfiguration connectorConfiguration : projectConfig.getConnectors()) {
                if (!connectorConfiguration.isRepositoryType(ERepositoryConnector.ABAP_GIT) || !sapConnectionIdentifier.equals(connectorConfiguration.getOptionValue("SAP connection"))) continue;
                String triggerName = connectorConfiguration.getIdentifier() + "-" + AbapChangeRetriever.class.getSimpleName();
                ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(indexLayer, projectInfo.getInternalId(), triggerName);
                isAnyProjectUpdated = true;
            }
        }
        return isAnyProjectUpdated;
    }

    @Deprecated
    public static void updateProjects(File repositoryLocation, IndexLayer indexLayer) throws StorageException {
        String repositoryPath = UniformPathUtils.normalizeAllSeparators((String)repositoryLocation.getPath());
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers(repositoryPath, indexLayer, null);
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers("file:" + repositoryPath, indexLayer, null);
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers("file:/" + repositoryPath, indexLayer, null);
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers("file://" + repositoryPath, indexLayer, null);
    }

    public static String getAbapVersionFromIndex(SapVersionIndex sapVersionIndex, Set<String> sapConfigurationIds) {
        try {
            List<String> usedAbapVersions = sapVersionIndex.getVersionsByConnectionId().entrySet().stream().filter(entry -> sapConfigurationIds.contains(entry.getKey())).map(Map.Entry::getValue).map(SapVersion::getAbapVersion).collect(Collectors.toList());
            if (usedAbapVersions.isEmpty()) {
                LOGGER.warn("Could not determine the used ABAP version automatically: No SAP system is connected.\nDefaulting to abaplint syntax version v740sp08.\nTo set a specific abaplint syntax version, please provide it in the analysis profile via the option `ABAPLint default language`.");
                return DEFAULT_ABAPLINT_ANALYSIS_VERSION;
            }
            return AbapProjectUtils.getLowestAbapLintCompatibleVersion(sapConfigurationIds, usedAbapVersions);
        }
        catch (StorageException e) {
            LOGGER.warn("Could not determine the used ABAP version automatically.\nDefaulting to abaplint syntax version v740sp08.\nPlease check the worker log for connection issues.");
            return DEFAULT_ABAPLINT_ANALYSIS_VERSION;
        }
    }

    private static String getLowestAbapLintCompatibleVersion(Set<String> sapConfigurationIds, List<String> abapVersions) {
        List<String> abapLintVersions = AbapProjectUtils.getCompatibleAbapLintVersions(abapVersions);
        String formattedAbapVersions = StringUtils.joinDifferentLastDelimiter(abapVersions.stream().distinct().toList(), (String)", ", (String)" and ");
        if (abapLintVersions.isEmpty()) {
            LOGGER.warn("Could not determine some abaplint compatible version for ABAP " + StringUtils.pluralize((String)"version", (int)abapVersions.size()) + formattedAbapVersions + ". Defaulting to v740sp08");
            return DEFAULT_ABAPLINT_ANALYSIS_VERSION;
        }
        String version = (String)abapLintVersions.stream().sorted().findFirst().get();
        String message = "This project uses SAP " + StringUtils.pluralize((String)"system", (int)sapConfigurationIds.size()) + ": " + StringUtils.joinDifferentLastDelimiter(sapConfigurationIds.stream().toList(), (String)", ", (String)" and ");
        message = message + " with ABAP " + StringUtils.pluralize((String)"version", (int)abapVersions.size()) + ": " + formattedAbapVersions;
        message = message + "\nabaplint syntax version " + version + " chosen from applicable abaplint syntax " + StringUtils.pluralize((String)"version", (int)abapLintVersions.size()) + ": " + StringUtils.joinDifferentLastDelimiter(abapLintVersions, (String)", ", (String)" and ") + ".";
        if (abapLintVersions.size() > 1) {
            message = message + "\nTo set a specific abaplint syntax version, please provide an abaplint.json file manually, either in the repository or in the analysis profile.";
            LOGGER.warn(message);
        } else {
            LOGGER.info(message);
        }
        return version;
    }

    @VisibleForTesting
    static Optional<String> getCompatibleAbapLintVersion(String version) {
        String threeDigitVersion = version.substring(0, 3);
        return switch (threeDigitVersion = AbapProjectUtils.resolveAbapVersionFromS4HanaComponent(threeDigitVersion)) {
            case "816" -> Optional.of("v758");
            case "758", "757", "756", "755", "754", "753", "752", "751", "750", "702", "700" -> Optional.of("v".concat(threeDigitVersion));
            case "740" -> Optional.of(AbapProjectUtils.getAbapLintCompatibleToAbapKernel740(version));
            default -> Optional.empty();
        };
    }

    @VisibleForTesting
    static List<String> getCompatibleAbapLintVersions(Collection<String> abapVersions) {
        return abapVersions.stream().map(AbapProjectUtils::getCompatibleAbapLintVersion).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private static String getAbapLintCompatibleToAbapKernel740(String version) {
        try {
            int supportPackageNumber = Integer.parseInt(version.substring(6));
            if (supportPackageNumber < 2) {
                return "v702";
            }
            if (supportPackageNumber < 5) {
                return "v740sp02";
            }
            if (supportPackageNumber < 8) {
                return "v740sp05";
            }
            return DEFAULT_ABAPLINT_ANALYSIS_VERSION;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Could not determine the ABAP Platform version from {}. Defaulting to ", (Object)version, (Object)e);
            return DEFAULT_ABAPLINT_ANALYSIS_VERSION;
        }
    }

    private static String resolveAbapVersionFromS4HanaComponent(String threeDigitVersion) {
        if (threeDigitVersion.length() != 3) {
            LOGGER.warn("Could not determine ABAP version from S/4Hana component version " + threeDigitVersion);
            return threeDigitVersion;
        }
        char lastCharacter = threeDigitVersion.charAt(2);
        if (Character.isDigit(lastCharacter)) {
            return threeDigitVersion;
        }
        return switch (lastCharacter) {
            case 'A' -> "750";
            case 'B' -> "751";
            case 'C' -> "752";
            case 'D' -> "753";
            case 'E' -> "754";
            case 'F' -> "755";
            case 'G' -> "756";
            case 'H' -> "757";
            case 'I' -> "758";
            default -> "758";
        };
    }

    public static ProjectConfiguration createTestConfiguration(PublicProjectId publicProjectId, String sapSystemId) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(publicProjectId.toString(), publicProjectId, "Some analysis profile");
        ConnectorConfiguration connectorConfiguration = new ConnectorConfiguration(ERepositoryConnector.ABAP_GIT.getReadableName(), "ABAP-GIT Connector");
        connectorConfiguration.setOptionValue("SAP connection", sapSystemId);
        projectConfiguration.addConnector(connectorConfiguration);
        return projectConfiguration;
    }

    private AbapProjectUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

