/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.index.gitbridge.abap.UpdateResult;
import com.teamscale.index.repository.SapConnectionStatusPersister;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapRepositoryImporter;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapRepositoryUpdater;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapTriggerUtils;
import com.teamscale.index.repository.sap.abapsystem.importer.AsynchronousAbapExportIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.importer.SapConnectionStatusIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.SapVersion;
import com.teamscale.index.repository.sap.abapsystem.importer.SapVersionIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AbapScovRestarter;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AsynchronousBatchJobExportScheduler;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SynchronousAbapExportRetriever;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryUtil;
import java.io.File;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;

public abstract class AbapSynchronizeTriggerBase
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String UNABLE_TO_OBTAIN_LOCK_MESSAGE = "Unable to lock export for configuration id";

    protected abstract EUpdateMode getTriggerMode();

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE_PARALLEL;
    }

    public void execute() throws StorageException {
        this.setLoggingContextInformation("ABAP System: " + this.getConfigurationId());
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)globalStorageSystem) || AbapTriggerUtils.isInMaintenanceMode(this.indexLayer)) {
            return;
        }
        try {
            this.retrieveAndStoreDataFromSapSystem(globalStorageSystem);
        }
        catch (SapSystemCommunicationException e) {
            String message = "An error occurred while communicating with SAP system: " + e.getMessage();
            LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log(message);
            this.setConnectionDownStatus(message);
        }
        catch (StorageException e) {
            String message = e.getMessage();
            this.setConnectionDownStatus(message);
            throw this.createIdentifiableException(message, e);
        }
        catch (NoClassDefFoundError e) {
            String message = "SAP JCo library has not been loaded. Please refer to the Teamscale documentation.";
            this.setConnectionDownStatus(message);
            throw this.createIdentifiableException(message, e);
        }
    }

    private void retrieveAndStoreDataFromSapSystem(GlobalStorageSystem globalStorageSystem) throws StorageException, SapSystemCommunicationException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        CanonicalFile repositoryLocation = AbapRepositoryUtil.buildRepositoryLocation(this.getConfigurationId(), serverOptionIndex);
        EUpdateMode updateMode = this.getUpdateMode((File)repositoryLocation);
        AbapSystemDescription abapSystemDescription = (AbapSystemDescription)this.getTriggeringOption(AbapSystemDescription.class);
        if (abapSystemDescription.fetchFromSapSystem && abapSystemDescription.executeFullSynchronizationAsynchronously && (updateMode == EUpdateMode.INITIAL || updateMode == EUpdateMode.FULL)) {
            this.scheduleAsynchronousExport(globalStorageSystem, abapSystemDescription, serverOptionIndex);
        } else {
            this.fetchAndImport((File)repositoryLocation, updateMode, globalStorageSystem, abapSystemDescription, serverOptionIndex);
        }
    }

    private void clearAbapHistoryIdLockForLockingUnrelatedErrors(String errorMessage, ServerOptionIndex serverOptionIndex, AbapSystemDescription abapSystemDescription) {
        if (errorMessage.contains(UNABLE_TO_OBTAIN_LOCK_MESSAGE)) {
            return;
        }
        if (!abapSystemDescription.fetchFromSapSystem) {
            return;
        }
        try {
            int returnCode = AbapRepositoryUtil.clearAbapHistoryIdLock(this.getConfigurationId(), serverOptionIndex, abapSystemDescription);
            if (returnCode == AbapRepositoryUtil.CLEAR_LOCK_SUCCESS_RETURN_CODE) {
                LOGGER.info("Successfully cleared ABAP history id lock after failed export.");
            } else {
                LOGGER.warn("Clearing ABAP history id lock after failed export returned non-zero return code: {}", (Object)returnCode);
            }
        }
        catch (SapSystemCommunicationException | StorageException e) {
            LOGGER.error("Unable to clear abap history id lock after failed export.", e);
        }
    }

    private EUpdateMode getUpdateMode(File repositoryLocation) {
        if (!AbapRepositoryUtil.repositoryIdentifierExists(repositoryLocation)) {
            return EUpdateMode.INITIAL;
        }
        return this.getTriggerMode();
    }

    private void scheduleAsynchronousExport(GlobalStorageSystem globalStorageSystem, AbapSystemDescription abapSystemDescription, ServerOptionIndex serverOptionIndex) throws StorageException, SapSystemCommunicationException {
        GlobalSapSystemConnectionOption globalSapConnectionOption = AbapSynchronizeTriggerBase.getSapConnectionOption(serverOptionIndex);
        String exportHistoryId = this.getRepositoryUpdater(globalStorageSystem, abapSystemDescription, serverOptionIndex).getExportHistoryId();
        AsynchronousAbapExportIndex asynchronousAbapExportIndex = AbapSynchronizeTriggerBase.getAsynchronousAbapExportIndex(globalStorageSystem);
        String jobUnitId = this.scheduleAsynchronousBatchExport(abapSystemDescription, globalSapConnectionOption, exportHistoryId);
        asynchronousAbapExportIndex.addScheduledAsynchronousAbapExport(jobUnitId, this.getConfigurationId());
        LOGGER.info("Scheduled asynchronous execution of ABAP export under unit id {}", (Object)jobUnitId);
    }

    private String scheduleAsynchronousBatchExport(AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapConnectionOption, String exportHistoryId) throws SapSystemCommunicationException {
        AsynchronousBatchJobExportScheduler exportScheduler = new AsynchronousBatchJobExportScheduler(this.getConfigurationId(), abapSystemDescription, globalSapConnectionOption, exportHistoryId);
        String batchJob = exportScheduler.scheduleBatchJob();
        LOGGER.info("Scheduled batch job in SAP system under job {}", (Object)batchJob);
        return exportScheduler.getJobUnitId();
    }

    private static AsynchronousAbapExportIndex getAsynchronousAbapExportIndex(GlobalStorageSystem globalStorageSystem) throws StorageException {
        return (AsynchronousAbapExportIndex)globalStorageSystem.openGlobalIndex(AsynchronousAbapExportIndex.class);
    }

    private void fetchAndImport(File repositoryLocation, EUpdateMode updateMode, GlobalStorageSystem globalStorageSystem, AbapSystemDescription abapSystemDescription, ServerOptionIndex serverOptionIndex) throws StorageException, SapSystemCommunicationException {
        try {
            GlobalSapSystemConnectionOption globalSapConnectionOption = AbapSynchronizeTriggerBase.getSapConnectionOption(serverOptionIndex);
            AbapRepositoryUpdater repositoryUpdater = this.getRepositoryUpdater(globalStorageSystem, abapSystemDescription, serverOptionIndex);
            Function<EUpdateMode, SynchronousAbapExportRetriever> abapExportRetrieverFactory = this.getExportRetrieverFactory(abapSystemDescription, globalSapConnectionOption, repositoryUpdater);
            AbapRepositoryImporter abapRepositoryImporter = new AbapRepositoryImporter(repositoryUpdater, abapExportRetrieverFactory, new AbapScovRestarter(this.getConfigurationId(), abapSystemDescription, globalSapConnectionOption), abapSystemDescription);
            UpdateResult result = abapRepositoryImporter.fetchAndImport(updateMode, repositoryLocation, new SapConnectionStatusPersister(this.getConfigurationId(), this.indexLayer, this.getSynchronizerName()));
            if (result.getSapVersion().isPresent()) {
                AbapSynchronizeTriggerBase.storeSystemVersion(this.getConfigurationId(), result.getSapVersion().get(), globalStorageSystem);
            }
        }
        catch (SapSystemCommunicationException | StorageException e) {
            String message = e.getMessage();
            this.clearAbapHistoryIdLockForLockingUnrelatedErrors(message, serverOptionIndex, abapSystemDescription);
            throw e;
        }
    }

    protected abstract String getSynchronizerName();

    private void setConnectionDownStatus(String message) {
        new SapConnectionStatusPersister(this.getConfigurationId(), this.indexLayer, this.getSynchronizerName()).setStatus(SapConnectionStatusIndex.ESapConnectionState.ERROR, message);
    }

    private static void storeSystemVersion(String connection, SapVersion version, GlobalStorageSystem globalStorageSystem) throws StorageException {
        SapVersionIndex versionIndex = (SapVersionIndex)globalStorageSystem.openGlobalIndex(SapVersionIndex.class);
        versionIndex.setVersion(connection, version);
    }

    private static GlobalSapSystemConnectionOption getSapConnectionOption(ServerOptionIndex serverOptionIndex) throws StorageException {
        return (GlobalSapSystemConnectionOption)ServerOptionRegistry.getInstance().getServerOption("sap.abap.global", GlobalSapSystemConnectionOption.class, serverOptionIndex);
    }

    private AbapRepositoryUpdater getRepositoryUpdater(GlobalStorageSystem globalStorageSystem, AbapSystemDescription abapSystemDescription, ServerOptionIndex serverOptionIndex) throws StorageException {
        return new AbapRepositoryUpdater(this.getConfigurationId(), abapSystemDescription.clearTestCoverage, serverOptionIndex, globalStorageSystem, this.indexLayer);
    }

    private Function<EUpdateMode, SynchronousAbapExportRetriever> getExportRetrieverFactory(AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapConnectionOption, AbapRepositoryUpdater repositoryUpdater) {
        return mode -> new SynchronousAbapExportRetriever(this.getConfigurationId(), abapSystemDescription, globalSapConnectionOption, repositoryUpdater.getExportHistoryId(), (EUpdateMode)((Object)mode));
    }

    private String getConfigurationId() {
        Preconditions.checkState((this.jobDescriptor.getParameter() != null ? 1 : 0) != 0, (Object)"The parameter needs to be set to get the configurationId.");
        return (String)OptionRegistryBase.extractOptionNameAndSelector((String)this.jobDescriptor.getParameter()).getSecond();
    }

    private StorageException createIdentifiableException(String message, Throwable cause) {
        return new StorageException(this.getConfigurationId() + ": " + message, cause);
    }
}

