/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@PeriodicMaintenanceJob(cronExpression="0 0 * * *")
public class AbapZipArchiveCleanupTrigger
extends MaintenanceTriggerBase {
    private static final String ARCHIVING_PERIOD_SYSTEM_PROPERTY_NAME = "com.teamscale.abap.archivingPeriodInDays";
    private static final int MAX_AGE_IN_DAYS = Integer.getInteger("com.teamscale.abap.archivingPeriodInDays", 90);

    public void execute() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.indexLayer.openGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        long ageThreshold = LocalDateTime.now().minusDays(MAX_AGE_IN_DAYS).toInstant(ZoneOffset.UTC).toEpochMilli();
        AbapZipArchiveCleanupTrigger.getSapConfigurationIds(serverOptionIndex).forEach(id -> AbapZipArchiveCleanupTrigger.pruneArchiveForConfiguration(id, ageThreshold, serverOptionIndex));
    }

    private static Stream<String> getSapConfigurationIds(ServerOptionIndex serverOptionIndex) throws StorageException {
        Set sapOptions = ServerOptionRegistry.getServerMultiOptionAll((String)"sap.abap.system", (ServerOptionIndex)serverOptionIndex).keySet();
        return sapOptions.stream().map(name -> (String)OptionRegistryBase.extractOptionNameAndSelector((String)name).getSecond());
    }

    private static void pruneArchiveForConfiguration(String configurationId, long ageThreshold, ServerOptionIndex serverOptionIndex) {
        try {
            CanonicalFile archiveDirectory = AbapRepositoryUtil.buildRepositoryLocation(configurationId, "archive", serverOptionIndex);
            AbapZipArchiveCleanupTrigger.pruneArchive(archiveDirectory, ageThreshold);
        }
        catch (StorageException e) {
            LogManager.getLogger().error("Failed to get archive location for configuration " + configurationId, (Throwable)e);
        }
    }

    private static void pruneArchive(CanonicalFile archiveDirectory, long ageThreshold) {
        for (File file : FileSystemUtils.listFilesRecursively((File)archiveDirectory, f -> f.lastModified() < ageThreshold)) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LogManager.getLogger().warn("Error pruning ABAP archive: Can't delete " + String.valueOf(file), (Throwable)e);
            }
        }
    }
}

