/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.teamscale.index.repository.sap.abapsystem.importer.AsynchronousAbapExport;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="asynchronous-abap-export", options={EStorageOption.COMPRESSED})
public class AsynchronousAbapExportIndex
implements IGlobalIndex {
    private final ValueIndex<AsynchronousAbapExport> delegate;

    public AsynchronousAbapExportIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<AsynchronousAbapExport> getAllScheduledAbapExports() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public void addScheduledAsynchronousAbapExport(String functionUnitId, String configurationId) throws StorageException {
        AsynchronousAbapExport asynchronousAbapExport = new AsynchronousAbapExport(functionUnitId, configurationId);
        String key = asynchronousAbapExport.getKey();
        if (this.delegate.getValue(key) != null) {
            throw new StorageException("Trying to store scheduled ABAP export, but index contains already an entry with key " + key);
        }
        this.delegate.setValue(key, (Object)asynchronousAbapExport);
    }

    public void removeScheduledAbapExport(AsynchronousAbapExport scheduledExport) throws StorageException {
        this.delegate.removeValue(scheduledExport.getKey());
    }
}

