/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.repository.SapConnectionStatusPersister;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapRepositoryUpdater;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapTriggerUtils;
import com.teamscale.index.repository.sap.abapsystem.importer.AsynchronousAbapExport;
import com.teamscale.index.repository.sap.abapsystem.importer.AsynchronousAbapExportIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.importer.SapConnectionStatusIndex;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.AsynchronousAbapExportFetcher;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class AsynchronousAbapUpdateTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private GlobalStorageSystem globalStorageSystem;
    private GlobalSapSystemConnectionOption globalSapConnectionOption;
    private ServerOptionIndex serverOptionIndex;
    private AsynchronousAbapExportIndex asynchronousAbapExportIndex;

    public void execute() throws StorageException {
        this.globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.globalStorageSystem) || AbapTriggerUtils.isInMaintenanceMode(this.indexLayer)) {
            return;
        }
        this.serverOptionIndex = (ServerOptionIndex)this.globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        this.globalSapConnectionOption = (GlobalSapSystemConnectionOption)ServerOptionRegistry.getInstance().getServerOption("sap.abap.global", GlobalSapSystemConnectionOption.class, this.serverOptionIndex);
        this.asynchronousAbapExportIndex = (AsynchronousAbapExportIndex)this.globalStorageSystem.openGlobalIndex(AsynchronousAbapExportIndex.class);
        for (AsynchronousAbapExport scheduledExport : this.asynchronousAbapExportIndex.getAllScheduledAbapExports()) {
            this.setLoggingContextInformation("ABAP System: " + scheduledExport.configurationId);
            try {
                this.processScheduledExport(scheduledExport);
            }
            catch (SapSystemCommunicationException e) {
                LOGGER.error("Error when fetching result for scheduled export " + String.valueOf(scheduledExport), (Throwable)e);
            }
        }
    }

    private void processScheduledExport(AsynchronousAbapExport scheduledExport) throws StorageException, SapSystemCommunicationException {
        AbapSystemDescription abapSystemDescription = AbapSystemDescription.getInstanceFromOptionIndex(scheduledExport.configurationId, this.serverOptionIndex);
        if (!this.shouldFetchFromSapSystem(abapSystemDescription, scheduledExport)) {
            return;
        }
        AsynchronousAbapExportFetcher exportFetcher = new AsynchronousAbapExportFetcher(scheduledExport.configurationId, abapSystemDescription, this.globalSapConnectionOption, scheduledExport.jobUnitId);
        this.removeJobsWaitingForLongTime(scheduledExport);
        this.updateRepositoryIfResultIsAvailable(scheduledExport, exportFetcher, abapSystemDescription);
    }

    private boolean shouldFetchFromSapSystem(AbapSystemDescription abapSystemDescription, AsynchronousAbapExport scheduledExport) throws StorageException {
        if (abapSystemDescription == null) {
            LOGGER.error("No SAP connection configured for id " + scheduledExport.configurationId + ". Removing leftover scheduled export.");
            this.deleteFromIndex(scheduledExport);
            return false;
        }
        return abapSystemDescription.fetchFromSapSystem;
    }

    private void updateRepositoryIfResultIsAvailable(AsynchronousAbapExport scheduledExport, AsynchronousAbapExportFetcher exportFetcher, AbapSystemDescription abapSystemDescription) throws StorageException, SapSystemCommunicationException {
        boolean hasResult = exportFetcher.execute();
        if (!hasResult) {
            LOGGER.debug(() -> "Result fetched for export " + scheduledExport.toString() + " is not present.");
            return;
        }
        LOGGER.debug(() -> "Got result for " + scheduledExport.toString() + ".");
        this.updateAbapGitRepository(exportFetcher.getZipContent(), scheduledExport, abapSystemDescription);
        this.deleteFromIndex(scheduledExport);
    }

    private void updateAbapGitRepository(byte[] zipContent, AsynchronousAbapExport scheduledExport, AbapSystemDescription abapSystemDescription) throws StorageException {
        if (zipContent == null) {
            String warning = "returned zip content is null";
            this.processErrorAndAbortFurtherQuerying(scheduledExport, warning);
            return;
        }
        if (zipContent.length == 0) {
            String warning = "returned zip content is empty";
            this.processErrorAndAbortFurtherQuerying(scheduledExport, warning);
            return;
        }
        AbapRepositoryUpdater repositoryUpdater = new AbapRepositoryUpdater(scheduledExport.configurationId, abapSystemDescription.clearTestCoverage, this.serverOptionIndex, this.globalStorageSystem, this.indexLayer);
        repositoryUpdater.saveWorkingFile(zipContent, EUpdateMode.FULL);
        SapConnectionStatusPersister statusPersister = new SapConnectionStatusPersister(scheduledExport.configurationId, this.indexLayer, scheduledExport.configurationId);
        try {
            repositoryUpdater.updateRepository(statusPersister);
        }
        catch (GitBridgeException e) {
            statusPersister.setStatus(SapConnectionStatusIndex.ESapConnectionState.ERROR, e.getMessage());
            throw new StorageException("Unable to update Git repository", (Throwable)e);
        }
    }

    private void deleteFromIndex(AsynchronousAbapExport scheduledExport) throws StorageException {
        this.asynchronousAbapExportIndex.removeScheduledAbapExport(scheduledExport);
    }

    private void removeJobsWaitingForLongTime(AsynchronousAbapExport scheduledExport) throws StorageException {
        long waitTimeSeconds = Duration.between(scheduledExport.scheduleTime, Instant.now()).getSeconds();
        if (waitTimeSeconds > (long)this.globalSapConnectionOption.maxAsynchronousWaitHours * 3600L) {
            this.processErrorAndAbortFurtherQuerying(scheduledExport, "was scheduled more than " + this.globalSapConnectionOption.maxAsynchronousWaitHours + " hours ago");
        }
    }

    private void processErrorAndAbortFurtherQuerying(AsynchronousAbapExport scheduledExport, String errorMessage) throws StorageException {
        this.deleteFromIndex(scheduledExport);
        LOGGER.error("ABAP export background job " + scheduledExport.getKey() + " " + errorMessage + " - Will not be queried anymore. Check in SAP system for errors.");
    }
}

