/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer;

import com.teamscale.index.repository.status.ProjectConnectorStatus;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="sap-connection-state", options={})
public class SapConnectionStatusIndex
implements IGlobalIndex {
    private static final String CONNECTOR_STATE_KEY_PREFIX = "S";
    private static final String CONNECTOR_STATE_MESSAGE_KEY_PREFIX = "M";
    private final ValueIndex<String> delegate;

    public SapConnectionStatusIndex(IStore store) {
        this.delegate = ValueIndex.forString((IStore)store);
    }

    public void setStatus(String sapConnectionId, ESapConnectionState status, String message) throws StorageException {
        PairList values = new PairList();
        values.add((Object)(CONNECTOR_STATE_KEY_PREFIX + sapConnectionId), (Object)status.name());
        values.add((Object)(CONNECTOR_STATE_MESSAGE_KEY_PREFIX + sapConnectionId), (Object)message);
        this.delegate.setValues(values);
    }

    public void removeDeletedSapConnections(Set<String> connectionIdsToRetain) throws StorageException {
        Set storedIds = this.delegate.getAllKeys().stream().map(key -> key.substring(1)).collect(Collectors.toSet());
        storedIds.removeAll(connectionIdsToRetain);
        ArrayList<CallSite> keysToRemove = new ArrayList<CallSite>();
        for (String sapConnectionId : storedIds) {
            keysToRemove.add((CallSite)((Object)(CONNECTOR_STATE_KEY_PREFIX + sapConnectionId)));
            keysToRemove.add((CallSite)((Object)(CONNECTOR_STATE_MESSAGE_KEY_PREFIX + sapConnectionId)));
        }
        this.delegate.removeValues(keysToRemove);
    }

    public @Nullable Pair<ESapConnectionState, @Nullable String> getStatus(String sapConnectionId) throws StorageException {
        String value = (String)this.delegate.getValue(CONNECTOR_STATE_KEY_PREFIX + sapConnectionId);
        if (value == null) {
            return null;
        }
        String message = (String)this.delegate.getValue(CONNECTOR_STATE_MESSAGE_KEY_PREFIX + sapConnectionId);
        return Pair.createPair((Object)((Object)ESapConnectionState.valueOf(value)), (Object)message);
    }

    public static enum ESapConnectionState {
        INITIAL,
        HEALTHY,
        ERROR;


        public  @NonNull ProjectConnectorStatus.EConnectorStatus convertToProjectConnectorStatus() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> ProjectConnectorStatus.EConnectorStatus.HEALTHY;
                case 2 -> ProjectConnectorStatus.EConnectorStatus.ERROR;
                case 0 -> ProjectConnectorStatus.EConnectorStatus.INIT;
            };
        }
    }
}

