/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.rfc;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.JcoDestinationDataProvider;
import com.teamscale.index.repository.sap.abapsystem.importer.rfc.SapSystemCommunicationException;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.jco.JcoReflectionUtils;
import org.conqat.engine.abap.jco.JcoUtils;
import org.conqat.engine.core.core.ConQATException;

public abstract class AbapRfcFunctionExecuterBase {
    protected final AbapSystemDescription abapSystemDescription;
    private final GlobalSapSystemConnectionOption globalSapOption;
    private JCoFunction function;
    private final String functionName;
    protected final String connectionName;

    protected AbapRfcFunctionExecuterBase(String connectionName, String functionName, AbapSystemDescription abapSystemDescription, GlobalSapSystemConnectionOption globalSapOption) {
        this.connectionName = connectionName;
        this.functionName = functionName;
        this.abapSystemDescription = abapSystemDescription;
        this.globalSapOption = globalSapOption;
    }

    public JCoDestination getDestination() throws SapSystemCommunicationException {
        if (!JcoReflectionUtils.isJCoLibraryLoaded()) {
            throw new SapSystemCommunicationException("SAP JCo library not loaded.");
        }
        JcoDestinationDataProvider.getInstance().setPropertiesFromSystemDescription(this.connectionName, this.abapSystemDescription, this.globalSapOption);
        try {
            return JcoUtils.getJcoDestination((String)this.connectionName);
        }
        catch (ConQATException e) {
            throw new SapSystemCommunicationException("Could not access SAP JCo connection " + this.connectionName);
        }
    }

    public void executeRfcFunction() throws SapSystemCommunicationException {
        if (this.globalSapOption.abapSystemLogonTimeout >= 1 && this.globalSapOption.abapSystemLogonTimeout <= 3600) {
            JCo.setProperty((String)"jrfc.client_connect_timeout", (String)String.valueOf(this.globalSapOption.abapSystemLogonTimeout));
        }
        JCoDestination destination = this.getDestinationAndSetJcoFunctionAndImportParameters();
        try {
            this.function.execute(destination);
        }
        catch (JCoException e) {
            throw new SapSystemCommunicationException("Error during executing ABAP function " + this.function.getName(), e);
        }
    }

    private JCoDestination getDestinationAndSetJcoFunctionAndImportParameters() throws SapSystemCommunicationException {
        JCoDestination destination = this.getDestination();
        try {
            this.function = JcoUtils.getJcoFunction((JCoDestination)destination, (String)this.functionName);
        }
        catch (ConQATException e) {
            throw new SapSystemCommunicationException("Error when accessing RFC function", e);
        }
        try {
            this.setImportParameters();
        }
        catch (ConQATException e) {
            throw new SapSystemCommunicationException("Error while initializing parameters for RFC function call " + this.function.getName(), e);
        }
        return destination;
    }

    public byte[] getByteArrayExportParameter(String parameterName) {
        return this.function.getExportParameterList().getByteArray(parameterName);
    }

    public boolean getBooleanExportParameter(String parameterName) {
        return AbapUtils.toBoolean((char)this.function.getExportParameterList().getChar(parameterName));
    }

    public String getStringExportParameter(String parameterName) {
        return this.function.getExportParameterList().getString(parameterName);
    }

    public int getIntExportParameter(String parameterName) {
        return this.function.getExportParameterList().getInt(parameterName);
    }

    protected abstract void setImportParameters() throws ConQATException;

    protected void setImportParameter(String name, String value) {
        this.function.getImportParameterList().setValue(name, value);
    }

    protected void setImportParameter(String name, byte[] value) {
        this.function.getImportParameterList().setValue(name, value);
    }

    protected void setImportParameter(String name, boolean value) {
        this.function.getImportParameterList().setValue(name, AbapUtils.toAbapBool((boolean)value));
    }

    protected void setImportParameterIfAvailable(String name, boolean value) {
        if (this.hasImportParameter(name)) {
            this.setImportParameter(name, value);
        }
    }

    protected void setImportParameterIfAvailable(String name, String value) {
        if (this.hasImportParameter(name)) {
            this.setImportParameter(name, value);
        }
    }

    private boolean hasImportParameter(String name) {
        for (JCoField parameter : this.function.getImportParameterList()) {
            if (!parameter.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

