/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.importer.snc;

import com.teamscale.index.findings.clangtidy.ProcessWrapper;
import com.teamscale.index.repository.sap.abapsystem.importer.snc.ISapgenpseRunner;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.system.SystemUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SapgenpseRunner
implements ISapgenpseRunner {
    private static final String SAPGENPSE_SECLOGIN_COMMAND_FORMAT = "%s seclogin -p %s";
    private static final String SAPGENPSE_SECLOGIN_WITH_USER_COMMAND_FORMAT = "%s seclogin -p %s -O %s";
    private final String securityDirectory;
    private final String sapgenpseExecutablePath;
    private final String osCredentialsUser;

    public SapgenpseRunner(String securityDirectory, String sapgenpseExecutablePath, String osCredentialsUser) {
        this.securityDirectory = securityDirectory;
        this.sapgenpseExecutablePath = sapgenpseExecutablePath;
        this.osCredentialsUser = osCredentialsUser;
    }

    @VisibleForTesting
    ProcessWrapper getProcessRunnerForWindows(List<String> pseFiles) {
        File securityDirFile = new File(this.securityDirectory);
        ProcessWrapper processWrapper = new ProcessWrapper("cmd.exe", Map.of("SECUDIR", securityDirFile.getAbsolutePath()));
        processWrapper.setWorkingDirectory(securityDirFile);
        processWrapper.addArgument("/c");
        processWrapper.addArgument(SapgenpseRunner.getSecloginCommand(this.sapgenpseExecutablePath, pseFiles.getFirst(), this.osCredentialsUser));
        for (int i = 1; i < pseFiles.size(); ++i) {
            processWrapper.addArgument(" && " + SapgenpseRunner.getSecloginCommand(this.sapgenpseExecutablePath, pseFiles.get(i), this.osCredentialsUser));
        }
        return processWrapper;
    }

    private static String getSecloginCommand(String pathToSapgenpse, String pseFile, String operatingSystemUser) {
        if (operatingSystemUser == null || operatingSystemUser.isEmpty()) {
            return SAPGENPSE_SECLOGIN_COMMAND_FORMAT.formatted(pathToSapgenpse, pseFile);
        }
        return SAPGENPSE_SECLOGIN_WITH_USER_COMMAND_FORMAT.formatted(pathToSapgenpse, pseFile, operatingSystemUser);
    }

    @VisibleForTesting
    ProcessWrapper getProcessRunnerForUnix(List<String> pseFiles) {
        File securityDirFile = new File(this.securityDirectory);
        ProcessWrapper processWrapper = new ProcessWrapper("bash", Map.of("SECUDIR", securityDirFile.getAbsolutePath()));
        processWrapper.setWorkingDirectory(securityDirFile);
        processWrapper.addArgument("-c");
        StringBuilder stringBuilder = new StringBuilder(SapgenpseRunner.getSecloginCommand(this.sapgenpseExecutablePath, pseFiles.getFirst(), this.osCredentialsUser));
        for (int i = 1; i < pseFiles.size(); ++i) {
            stringBuilder.append(" && ").append(SapgenpseRunner.getSecloginCommand(this.sapgenpseExecutablePath, pseFiles.get(i), this.osCredentialsUser));
        }
        processWrapper.addArgument(stringBuilder.toString());
        return processWrapper;
    }

    private static ISapgenpseRunner.ExecutionResult getResultFromProcessWrapper(ProcessWrapper processWrapper) {
        StringBuffer output = new StringBuffer();
        StringBuffer errorsAndWarnings = new StringBuffer();
        processWrapper.setOutputConsumer(line -> output.append((String)line).append("\n"));
        processWrapper.setErrorConsumer(line -> errorsAndWarnings.append((String)line).append("\n"));
        int returnCode = processWrapper.runWithTimeout(1);
        return new ISapgenpseRunner.ExecutionResult(returnCode, output.toString(), errorsAndWarnings.toString());
    }

    @Override
    public ISapgenpseRunner.ExecutionResult createCredentials(List<String> sortedPseFiles) {
        ProcessWrapper processWrapper = SystemUtils.isWindows() ? this.getProcessRunnerForWindows(sortedPseFiles) : this.getProcessRunnerForUnix(sortedPseFiles);
        return SapgenpseRunner.getResultFromProcessWrapper(processWrapper);
    }

    private ProcessWrapper getProcessWrapperWithBaseArguments() {
        ProcessWrapper processWrapper = new ProcessWrapper(this.sapgenpseExecutablePath);
        processWrapper.setWorkingDirectory(new File(this.securityDirectory));
        processWrapper.addArgument("seclogin");
        if (this.osCredentialsUser != null && !this.osCredentialsUser.isEmpty()) {
            processWrapper.addArgument("-O");
            processWrapper.addArgument(this.osCredentialsUser);
        }
        return processWrapper;
    }

    @Override
    public ISapgenpseRunner.ExecutionResult viewCredentials() {
        ProcessWrapper processWrapper = this.getProcessWrapperWithBaseArguments();
        processWrapper.addArgument("-l");
        return SapgenpseRunner.getResultFromProcessWrapper(processWrapper);
    }

    @Override
    public ISapgenpseRunner.ExecutionResult addPseIntoCredentials(String pseFile) {
        ProcessWrapper processWrapper = this.getProcessWrapperWithBaseArguments();
        processWrapper.addArgument("-p");
        processWrapper.addArgument(pseFile);
        return SapgenpseRunner.getResultFromProcessWrapper(processWrapper);
    }

    @Override
    public ISapgenpseRunner.ExecutionResult removePseFromCredentials(String pseFile) {
        ProcessWrapper processWrapper = this.getProcessWrapperWithBaseArguments();
        processWrapper.addArgument("-d");
        processWrapper.addArgument("-p");
        processWrapper.addArgument(pseFile);
        return SapgenpseRunner.getResultFromProcessWrapper(processWrapper);
    }
}

