/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.repository;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.sap.abapsystem.importer.SapConnectionStatusIndex;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryConnector;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class AbapChangeRetriever
extends RepositoryChangeRetrieverBase {
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SapConnectionStatusIndex sapConnectionStatusIndex;
    @StepParameterObject
    private final AbapRepositoryConnector connector = new AbapRepositoryConnector();

    @Override
    protected IRepositoryConnection createRepositoryConnection() throws RepositoryException {
        return this.connector.createConnection(this.getProfilingMonitor(), (ICancelable)this, this.getParallelTaskExecutor());
    }

    @Override
    protected String getConnectionIdentifier() {
        return this.connector.getBaseParameters().getConnectionIdentifier();
    }

    @Override
    protected void storeConnectorDownStatus(Throwable t) throws StorageException {
        this.syncSapConnectionStatus();
    }

    @Override
    protected void storeConnectorUpStatus() throws StorageException {
        this.syncSapConnectionStatus();
    }

    @Override
    protected void storeConnectorInitStatus() throws StorageException {
        this.syncSapConnectionStatus();
    }

    @Override
    protected void storeConnectorDownStatus(String connectionIdentifier, String errorMessage) throws StorageException {
        this.syncSapConnectionStatus();
    }

    @Override
    protected void storeConnectorWarningStatus(Exception e) throws StorageException {
        this.syncSapConnectionStatus();
    }

    @Override
    protected void storeConnectorWarningStatus(String connectionIdentifier, String warningMessage) throws StorageException {
        this.syncSapConnectionStatus();
    }

    private void syncSapConnectionStatus() throws StorageException {
        Pair<SapConnectionStatusIndex.ESapConnectionState, @Nullable String> sapConnectionStatus = this.sapConnectionStatusIndex.getStatus(this.connector.sapConnectionIdentifier);
        if (sapConnectionStatus == null) {
            this.connectorStatusIndex.storeConnectorStatus(this.connector.getBaseParameters().getConnectionIdentifier(), ProjectConnectorStatus.EConnectorStatus.INIT, "");
            return;
        }
        String message = StringUtils.emptyIfNull((String)((String)sapConnectionStatus.getSecond()));
        this.connectorStatusIndex.storeConnectorStatus(this.connector.getBaseParameters().getConnectionIdentifier(), ((SapConnectionStatusIndex.ESapConnectionState)((Object)sapConnectionStatus.getFirst())).convertToProjectConnectorStatus(), message);
    }
}

