/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.repository;

import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBase;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapGitRepositoryConnection;
import com.teamscale.index.repository.sap.abapsystem.repository.AbapRepositoryConnectorDescriptor;
import java.io.File;
import java.net.URI;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

public class AbapRepositoryConnector
extends RepositoryConnectorBase<AbapGitRepositoryConnection> {
    public static final String SAP_CONNECTION_IDENTIFIER_PARAMETER = "sap-connection-identifier";
    @StepParameterObject
    private final GitRepositoryConnectorParameterStep gitParameters = GitRepositoryConnectorParameterStep.builder(new GitRepositoryConnectorParameterStep()).withConnectorType(ERepositoryConnector.ABAP_GIT).build();
    @StepParameter(value="sap-connection-identifier", optional=true)
    protected String sapConnectionIdentifier = null;

    @Override
    public AbapGitRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        String userName = "";
        String password = "";
        GitPrivateKeyOption privateKeyOption = null;
        try {
            File expectedGitDir = new File(AbapRepositoryConnectorDescriptor.getGitDirPath(this.sapConnectionIdentifier, this.gitParameters.getServerOptionIndex()));
            if (!expectedGitDir.exists() || !new File(expectedGitDir, ".git").exists()) {
                throw new RepositoryException("There is no git repository at the expected location " + String.valueOf(expectedGitDir) + ". If you are updating the Teamscale Server, you need to copy/link the sap.abap.system directory from the previous Teamscale to keep those commits. If you set up a new instance, the next invocation of the SAP synchronization should create the git repository and make this error disappear.");
            }
            URI repositoryUri = AbapRepositoryConnector.getRepositoryUri(this.sapConnectionIdentifier, this.gitParameters.getServerOptionIndex());
            return new AbapGitRepositoryConnection(this.getBaseParameters(), this.gitParameters, repositoryUri, userName, password, privateKeyOption, cancelable);
        }
        catch (ProjectConfigurationException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    public static URI getRepositoryUri(String sapConnectionIdentifier, ServerOptionIndex optionIndex) throws ProjectConfigurationException {
        try {
            String combinedPath = AbapRepositoryConnectorDescriptor.getGitDirPath(sapConnectionIdentifier, optionIndex).toString();
            return GitRepositoryConnector.adjustGitUrlAndConvertToUri(combinedPath);
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }
}

