/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sca;

import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.repository.sca.BuildComponent;
import com.teamscale.index.repository.sca.CompositionViolation;
import com.teamscale.index.repository.sca.IgnoreRuleApprovalState;
import com.teamscale.index.repository.sca.IgnoreViolationRequest;
import com.teamscale.index.repository.sca.NameWithVersion;
import java.io.Serializable;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public record IgnoreViolationRule(@Nullable String tsCreatorUser, String id, String created, String notes, @Nullable String expires_at, IgnoreViolationRequest ignoreFilters, @Nullable String xrayRuleId, @Nullable String xrayProjectKey, String tsAccountIdentifier, @Nullable IgnoreRuleApprovalState approvalState) implements Serializable
{
    public IgnoreViolationRule with(IgnoreRuleApprovalState approvalState) {
        return new IgnoreViolationRule(this.tsCreatorUser, this.id, this.created, this.notes, this.expires_at, this.ignoreFilters, this.xrayRuleId, this.xrayProjectKey, this.tsAccountIdentifier, approvalState);
    }

    public IgnoreViolationRule withXrayRuleId(String xrayRuleId) {
        return new IgnoreViolationRule(this.tsCreatorUser, this.id, this.created, this.notes, this.expires_at, this.ignoreFilters, xrayRuleId, this.xrayProjectKey, this.tsAccountIdentifier, this.approvalState);
    }

    public boolean matches(CompositionViolation violation) {
        return this.matchesComponent(violation.getComponents()) && this.matchesBuild(violation.getBuild()) && this.matchesVulnerabilityId(violation.getVulnerabilityId());
    }

    private boolean matchesVulnerabilityId(String vulnerabilityId) {
        if (StringUtils.isEmpty((String)this.ignoreFilters.xrayIssueId())) {
            return true;
        }
        return vulnerabilityId.equals(this.ignoreFilters.xrayIssueId());
    }

    private boolean matchesComponent(List<BuildComponent> components) {
        if (this.ignoreFilters.components().isEmpty()) {
            return true;
        }
        return components.stream().anyMatch(component -> this.ignoreFilters.components().stream().anyMatch(ignoredComponent -> ignoredComponent.name().equals(component.name()) && StringUtils.isEmpty((String)ignoredComponent.version()) || ignoredComponent.version().equals(component.version())));
    }

    private boolean matchesBuild(NameWithVersion build) {
        if (this.ignoreFilters.build() == null) {
            return true;
        }
        return build.name().equals(this.ignoreFilters().build().name()) && (StringUtils.isEmpty((String)this.ignoreFilters().build().version()) || this.ignoreFilters().build().version().equals(build.version()));
    }

    public boolean isPendingApproval() {
        return this.approvalState() != null && this.approvalState().state() == FindingBlacklistEvent.EExtendedBlacklistChangeType.PENDING_EXCLUSION;
    }
}

