/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalsInfo;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.ByteArrayComparator;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.ResultListCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Index(name="svn-log-cache-placeholder", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.NO_ROLLBACK}, valueClasses={SvnChangeEntry.class})
public class SvnLogCacheIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String PLACEHOLDER = "svn-log-cache-placeholder";
    private static final byte[] REVISION_SEPARATOR = new byte[]{1};
    private static final byte[] TIMESTAMP_SEPARATOR = new byte[]{2};
    private static final byte[] EXTERNAL_INFOS_PREFIX = new byte[]{3};
    private static final byte[] PERSISTED_CHANGE_ENTRY_PREFIX = new byte[]{4};
    private static final byte @NonNull [] LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY = StringUtils.stringToBytes((String)"##latest##");

    public static String createIndexName(String connectorId) {
        return IProjectIndexWithDynamicName.createIndexName((String)connectorId, (String)PLACEHOLDER);
    }

    public SvnLogCacheIndex(IStore store) {
        super(store);
    }

    public void insertLogEntries(List<SvnChangeEntry> entries) throws StorageException {
        PairList keysValues = new PairList();
        for (SvnChangeEntry entry : entries) {
            keysValues.add((Object)SvnLogCacheIndex.makeRevisionKey(entry.getRepositoryRoot(), entry.getRevision()), (Object)StorageUtils.serialize((Serializable)entry));
            keysValues.add((Object)SvnLogCacheIndex.makeTimestampKey(entry.getRepositoryRoot(), entry.getTimestamp()), (Object)SvnLogCacheIndex.makeRevisionValue(entry.getRevision(), false));
        }
        this.store.put(keysValues);
    }

    public void insertTimestampToRevisionMapping(long timestamp, long revision, String repositoryRoot) throws StorageException {
        this.store.put(SvnLogCacheIndex.makeTimestampKey(repositoryRoot, timestamp), SvnLogCacheIndex.makeRevisionValue(revision, true));
    }

    private static byte[] makeRevisionValue(long revision, boolean isArtificial) {
        if (isArtificial) {
            revision = -revision;
        }
        return ByteArrayUtils.longToByteArray((long)revision);
    }

    private static long extractRevisionValue(byte[] value) {
        return Math.abs(ByteArrayUtils.byteArrayToLong((byte[])value));
    }

    private static boolean isArtificialRevision(byte[] value) {
        return ByteArrayUtils.byteArrayToLong((byte[])value) < 0L;
    }

    private static byte[] makeTimestampKey(String repositoryRoot, long timestamp) {
        return SvnLogCacheIndex.makeTimestampKey(StringUtils.stringToBytes((String)repositoryRoot), timestamp);
    }

    private static byte[] makeTimestampKey(byte[] repositoryRoot, long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{repositoryRoot, TIMESTAMP_SEPARATOR, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    private static byte[] makeRevisionKey(String repositoryRoot, long revision) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)repositoryRoot), REVISION_SEPARATOR, ByteArrayUtils.longToByteArray((long)revision)});
    }

    public SvnChangeEntry getRepositoryLog(String repositoryRoot, long revision) throws StorageException {
        return (SvnChangeEntry)StorageUtils.deserialize((byte[])this.store.get(SvnLogCacheIndex.makeRevisionKey(repositoryRoot, revision)));
    }

    public List<SvnChangeEntry> getLogEntriesAfter(String repositoryRoot, long revision) throws StorageException {
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(SvnLogCacheIndex.makeRevisionKey(repositoryRoot, revision + 1L), SvnLogCacheIndex.makeRevisionKey(repositoryRoot, Long.MAX_VALUE), (IKeyValueCallback)callback);
        List result = callback.getResultOrThrowException();
        Collections.sort(result);
        return result;
    }

    public Optional<Long> getRevisionForExactTimestamp(String repositoryRoot, long timestamp) throws StorageException {
        byte[] value = this.store.get(SvnLogCacheIndex.makeTimestampKey(repositoryRoot, timestamp));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(SvnLogCacheIndex.extractRevisionValue(value));
    }

    public long getOriginRevisionForTimestamp(String repositoryRoot, long timestamp) throws StorageException {
        byte[] repositoryRootBytes = StringUtils.stringToBytes((String)repositoryRoot);
        byte[] exactMatch = this.store.get(SvnLogCacheIndex.makeTimestampKey(repositoryRootBytes, timestamp));
        if (exactMatch != null) {
            return SvnLogCacheIndex.extractRevisionValue(exactMatch);
        }
        long delta = 86400000L;
        long upperKey = timestamp;
        long lowerKey = Math.max(0L, upperKey - delta);
        while (upperKey > 0L) {
            AtomicLong maxRevision = new AtomicLong();
            this.store.scan(SvnLogCacheIndex.makeTimestampKey(repositoryRootBytes, lowerKey), SvnLogCacheIndex.makeTimestampKey(repositoryRootBytes, upperKey), (key, value) -> maxRevision.accumulateAndGet(SvnLogCacheIndex.extractRevisionValue(value), Math::max));
            long computedMaxRevision = maxRevision.get();
            if (computedMaxRevision > 0L) {
                return computedMaxRevision;
            }
            upperKey = lowerKey;
            lowerKey = Math.max(0L, upperKey - (delta *= 2L));
        }
        return 0L;
    }

    public void insertExternalInfos(long timestamp, SvnExternalsInfo externalInfos) throws StorageException {
        long latestTimestamp;
        byte[] latestTimestampBytes = this.store.get(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY);
        if (latestTimestampBytes != null && timestamp <= (latestTimestamp = ByteArrayUtils.byteArrayToLong((byte[])latestTimestampBytes))) {
            throw new StorageException("May not insert external infos for timestamp " + timestamp + " as already stored for larger timestamp " + latestTimestamp + " (violation of chronological insertion)");
        }
        this.store.put(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY, ByteArrayUtils.longToByteArray((long)timestamp));
        this.store.put(SvnLogCacheIndex.makeExternalInfosKey(timestamp), StorageUtils.serialize((Serializable)externalInfos));
    }

    private static byte[] makeExternalInfosKey(long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{EXTERNAL_INFOS_PREFIX, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    public SvnExternalsInfo getLatestExternalInfos() throws StorageException {
        byte[] latestTimestampBytes = this.store.get(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY);
        if (latestTimestampBytes == null) {
            return new SvnExternalsInfo();
        }
        long latestTimestamp = ByteArrayUtils.byteArrayToLong((byte[])latestTimestampBytes);
        return (SvnExternalsInfo)StorageUtils.deserialize((byte[])this.store.get(SvnLogCacheIndex.makeExternalInfosKey(latestTimestamp)));
    }

    public SvnExternalsInfo getExternalInfos(long timestamp) throws StorageException {
        byte[] latestTimestampBytes = this.store.get(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY);
        if (latestTimestampBytes == null) {
            return null;
        }
        long latestTimestamp = ByteArrayUtils.byteArrayToLong((byte[])latestTimestampBytes);
        if (timestamp >= latestTimestamp) {
            return (SvnExternalsInfo)StorageUtils.deserialize((byte[])this.store.get(SvnLogCacheIndex.makeExternalInfosKey(latestTimestamp)));
        }
        return this.scanForClosestExternalInfos(timestamp);
    }

    private SvnExternalsInfo scanForClosestExternalInfos(long timestamp) throws StorageException {
        long delta = Duration.ofMinutes(5L).toMillis();
        long upperKey = timestamp + 1L;
        long lowerKey = Math.max(0L, upperKey - delta);
        while (upperKey > 0L) {
            Pair<byte[], byte[]> bestKeyAndValue = this.getBestKeyAndValue(lowerKey, upperKey);
            if (bestKeyAndValue.getSecond() != null) {
                return (SvnExternalsInfo)StorageUtils.deserialize((byte[])((byte[])bestKeyAndValue.getSecond()));
            }
            upperKey = lowerKey;
            lowerKey = Math.max(0L, upperKey - (delta *= 2L));
        }
        return null;
    }

    private Pair<byte[], byte[]> getBestKeyAndValue(long lowerKey, long upperKey) throws StorageException {
        Pair bestKeyAndValue = new Pair(null, null);
        this.store.scan(SvnLogCacheIndex.makeExternalInfosKey(lowerKey), SvnLogCacheIndex.makeExternalInfosKey(upperKey), (key, value) -> {
            Pair pair = bestKeyAndValue;
            synchronized (pair) {
                if (bestKeyAndValue.getFirst() == null || ByteArrayComparator.INSTANCE.compare((byte[])bestKeyAndValue.getFirst(), key) < 0) {
                    bestKeyAndValue.setFirst((Object)key);
                    bestKeyAndValue.setSecond((Object)value);
                }
            }
        });
        return bestKeyAndValue;
    }

    public boolean isEmpty() throws StorageException {
        return this.store.get(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY) == null;
    }

    public void invalidateInformationStartingFrom(long timestamp, Collection<String> affectedRepositoryRoots) throws StorageException {
        StorageUtils.deleteRange((ConvenientStore)this.store, (byte[])SvnLogCacheIndex.makeExternalInfosKey(timestamp), (byte[])SvnLogCacheIndex.makeExternalInfosKey(Long.MAX_VALUE));
        this.store.remove(LATEST_EXTERNAL_INFOS_TIMESTAMP_KEY);
        List deletedKeys = Collections.synchronizedList(new ArrayList());
        for (String repositoryRoot : affectedRepositoryRoots) {
            byte[] startKey = SvnLogCacheIndex.makeTimestampKey(repositoryRoot, timestamp);
            byte[] endKey = SvnLogCacheIndex.makeTimestampKey(repositoryRoot, Long.MAX_VALUE);
            this.store.scan(startKey, endKey, (key, value) -> {
                deletedKeys.add(key);
                long revision = SvnLogCacheIndex.extractRevisionValue(value);
                if (!SvnLogCacheIndex.isArtificialRevision(value)) {
                    deletedKeys.add(SvnLogCacheIndex.makeRevisionKey(repositoryRoot, revision));
                }
            });
        }
        this.store.remove(deletedKeys);
    }

    public void persistChangeEntries(List<SvnChangeEntry> entries) throws StorageException {
        PairList keysValues = new PairList();
        for (SvnChangeEntry entry : entries) {
            keysValues.add((Object)SvnLogCacheIndex.makePersistedChangeEntryKey(entry.getTimestamp()), (Object)StorageUtils.serialize((Serializable)entry));
        }
        this.store.put(keysValues);
    }

    private static byte[] makePersistedChangeEntryKey(long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{PERSISTED_CHANGE_ENTRY_PREFIX, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    public List<SvnChangeEntry> getPersistedEntries(long timestamp) throws StorageException {
        byte[] beginKey = SvnLogCacheIndex.makePersistedChangeEntryKey(timestamp);
        byte[] endKey = SvnLogCacheIndex.makePersistedChangeEntryKey(Long.MAX_VALUE);
        ResultListCallback callback = new ResultListCallback();
        this.store.scan(beginKey, endKey, (IKeyValueCallback)callback);
        List result = callback.getResultOrThrowException();
        Collections.sort(result, Comparator.comparing(SvnChangeEntry::getTimestamp));
        return result;
    }
}

