/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.gitlab;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.gitlab.GitLabIssueConnectorDescriptor;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.triggers.gitlab.GitLabSpecItemSynchronizer;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ConnectorDescriptor
public class GitLabSpecItemConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @ConfigExposed(name="Project", description="The **global** (numeric) project ID, or the complete path (&lt;namespace&gt;/&lt;projectPath&gt;) of the GitLab project.")
    private String project;
    @ConfigExposed(name="Labels", description="Comma-separated list of labels. Only issues with any of these labels are imported. Leave empty to import all issues.")
    private List<String> labels = Collections.emptyList();
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(this::validateAccountDetails, false);

    public GitLabSpecItemConnectorDescriptor() {
        super(ERequirementsManagementTool.GITLAB);
        this.autoExpose();
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        GitLabIssueConnectorDescriptor.configureGitlabSynchronizerParameters(issueTrackerTriggerBuilder, this.project, this.labels);
        issueTrackerTriggerBuilder.resolveIndexNamePlaceholder("work-item-cleanup-index-placeholder", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return GitLabSpecItemSynchronizer.class;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        GitLabIssueConnectorDescriptor.validate(this.project);
        super.validate();
    }

    private void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        GitLabIssueConnectorDescriptor.validateAccountDetails(url, password, this.project, this.labels, LOGGER);
    }
}

