/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.core.index.ICommitDescriptorSerializer;
import com.teamscale.index.requirements_tracing.index.WorkItemChange;
import com.teamscale.index.requirements_tracing.index.WorkItemChangeCacheFactory;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.WiaUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Index(name="temp-spec-items-placeholder", options={EStorageOption.COMPRESSED}, valueClasses={WorkItemChange.class})
public class TempWorkItemIndex
extends ProjectIndexWithDynamicNameBase
implements IRollbackableIndex {
    public static final String PLACEHOLDER = "temp-spec-items-placeholder";
    private static final String LAST_CHANGE_TIMESTAMP_KEY = "###last-change-timestamp-key###";
    private static final ICommitDescriptorSerializer COMMIT_DESCRIPTOR_SERIALIZER = ICommitDescriptorSerializer.BranchTimestamp.DEFAULT;

    public TempWorkItemIndex(IStore store) {
        super(store);
    }

    public static String getIndexNameForRepository(String repositoryIdentifier) {
        return IProjectIndexWithDynamicName.createIndexName((String)repositoryIdentifier, (String)PLACEHOLDER);
    }

    private static String getRepositoryIdentifierFromIndexName(String indexName) {
        return StringUtils.stripSuffix((String)indexName, (String)TempWorkItemIndex.getIndexNameForRepository(""));
    }

    public void storeChangesForCommit(CommitDescriptor commit, Collection<WorkItemChange> changes) throws StorageException {
        this.store.put(TempWorkItemIndex.createCommitKey(commit), StorageUtils.serialize(new ArrayList<WorkItemChange>(changes)));
    }

    void storeChangesForBranch(String branch, Map<Long, ArrayList<WorkItemChange>> workItemChanges) throws StorageException {
        PairList keysAndValues = new PairList(workItemChanges.size());
        for (Map.Entry<Long, ArrayList<WorkItemChange>> entry : workItemChanges.entrySet()) {
            keysAndValues.add((Object)TempWorkItemIndex.createCommitKey(new CommitDescriptor(branch, entry.getKey().longValue())), (Object)StorageUtils.serialize((Serializable)entry.getValue()));
        }
        this.store.put(keysAndValues);
    }

    public void removeChangesForCommit(CommitDescriptor commit) throws StorageException {
        this.store.remove(TempWorkItemIndex.createCommitKey(commit));
    }

    private static byte[] createCommitKey(CommitDescriptor commit) {
        return COMMIT_DESCRIPTOR_SERIALIZER.serialize(commit);
    }

    void removeChangesForBranch(String branch) throws StorageException {
        this.store.removeByPrefix(branch);
    }

    public ArrayList<WorkItemChange> getChangesForCommit(CommitDescriptor commit) throws StorageException {
        byte[] value = this.store.get(TempWorkItemIndex.createCommitKey(commit));
        if (value == null) {
            return new ArrayList<WorkItemChange>();
        }
        return (ArrayList)StorageUtils.deserialize((byte[])value);
    }

    public List<ArrayList<WorkItemChange>> getChangesForCommits(List<CommitDescriptor> commits) throws StorageException {
        List<byte[]> keys = commits.stream().map(TempWorkItemIndex::createCommitKey).toList();
        List values = this.store.get(keys);
        ArrayList<ArrayList<WorkItemChange>> result = new ArrayList<ArrayList<WorkItemChange>>(values.size());
        for (byte[] value : values) {
            result.add((ArrayList)StorageUtils.deserialize((byte[])value));
        }
        return result;
    }

    public List<CommitDescriptor> getAllCommits() throws StorageException {
        ArrayList keys = new ArrayList();
        this.store.scanKeys("", (IKeyValueCallback)new KeyCollectingCallback(keys));
        byte[] lastChangeTimestampKeyBytes = StringUtils.stringToBytes((String)LAST_CHANGE_TIMESTAMP_KEY);
        return keys.stream().filter(key -> !Arrays.equals(key, lastChangeTimestampKeyBytes)).map(arg_0 -> ((ICommitDescriptorSerializer)COMMIT_DESCRIPTOR_SERIALIZER).deserialize(arg_0)).filter(commit -> !commit.getBranchName().startsWith("__WorkItemChangeCache__")).toList();
    }

    public WorkItemChangeCacheFactory getWorkItemChangeCacheFactory() {
        return new WorkItemChangeCacheFactory(this);
    }

    @VisibleForTesting
    public <T extends TeamscaleIssue> Set<T> getAllItems(Class<T> itemType, Instant until) throws StorageException {
        List<CommitDescriptor> allCommits = this.getAllCommits().stream().filter(commit -> commit.getTimestamp() < until.toEpochMilli()).toList();
        HashMap itemForId = new HashMap();
        for (CommitDescriptor commit2 : allCommits) {
            this.extractWorkItemChangeFromCommit(itemForId, itemType, commit2);
        }
        return new HashSet(itemForId.values());
    }

    @VisibleForTesting
    public <T extends TeamscaleIssue> @Nullable T getItem(Class<T> itemType, TeamscaleIssueId id, Instant until) throws StorageException {
        List<CommitDescriptor> commits = this.getAllCommits().stream().filter(commit -> commit.getTimestamp() < until.toEpochMilli()).sorted(Comparator.reverseOrder()).toList();
        for (CommitDescriptor commit2 : commits) {
            ArrayList<WorkItemChange> changes = this.getChangesForCommit(commit2);
            for (WorkItemChange change : changes) {
                if (!id.equals((Object)change.getWorkItemId())) continue;
                return (T)(switch (change.getChangeType()) {
                    default -> throw new MatchException(null, null);
                    case WorkItemChange.EType.UPDATE -> (TeamscaleIssue)itemType.cast(change.getUpdatedItem());
                    case WorkItemChange.EType.DELETION -> null;
                });
            }
        }
        return null;
    }

    private <T> void extractWorkItemChangeFromCommit(Map<TeamscaleIssueId, T> itemForId, Class<T> itemType, CommitDescriptor commit) throws StorageException {
        ArrayList<WorkItemChange> changes = this.getChangesForCommit(commit);
        for (WorkItemChange change : changes) {
            TempWorkItemIndex.handleWorkItemChange(itemForId, itemType, change);
        }
    }

    private static <T> void handleWorkItemChange(Map<TeamscaleIssueId, T> itemForId, Class<T> itemType, WorkItemChange change) {
        switch (change.getChangeType()) {
            case UPDATE: {
                TeamscaleIssue updatedItem = change.getUpdatedItem();
                if (!itemType.equals(updatedItem.getClass())) break;
                itemForId.put(change.getWorkItemId(), itemType.cast(updatedItem));
                break;
            }
            case DELETION: {
                itemForId.remove(change.getWorkItemId());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected value: " + String.valueOf((Object)change.getChangeType()));
            }
        }
    }

    public OptionalLong getLastChange() throws StorageException {
        byte[] value = this.store.getWithString(LAST_CHANGE_TIMESTAMP_KEY);
        if (value == null) {
            return OptionalLong.empty();
        }
        long millis = ByteArrayUtils.byteArrayToLong((byte[])value);
        return OptionalLong.of(millis);
    }

    public void setLastChange(Long lastChange) throws StorageException {
        if (lastChange == null) {
            this.store.removeWithString(LAST_CHANGE_TIMESTAMP_KEY);
        } else {
            byte[] value = ByteArrayUtils.longToByteArray((long)lastChange);
            this.store.putWithString(LAST_CHANGE_TIMESTAMP_KEY, value);
        }
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        String connectorId = TempWorkItemIndex.getRepositoryIdentifierFromIndexName(this.getName());
        String managedBranch = WiaUtils.getWorkItemConnectorBranchName((String)connectorId);
        Long rollbackTimestamp = timestampByBranch.get(managedBranch);
        if (rollbackTimestamp == null) {
            return;
        }
        List<CommitDescriptor> allCommits = this.getAllCommits();
        long newLastChangeTimestamp = -rollbackTimestamp.longValue();
        for (CommitDescriptor commitDescriptor : allCommits) {
            if (commitDescriptor.getTimestamp() > rollbackTimestamp) {
                this.removeChangesForCommit(commitDescriptor);
                continue;
            }
            newLastChangeTimestamp = Math.max(commitDescriptor.getTimestamp(), newLastChangeTimestamp);
        }
        this.setLastChange(newLastChangeTimestamp);
    }
}

