/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import com.teamscale.index.requirements_tracing.index.WorkItemChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NonNull;

public final class WorkItemChangeCache {
    public static final int MAXIMUM_CACHED_CHANGES = 100000;
    private final TempWorkItemIndex tempWorkItemIndex;
    private final Object lock = new Object();
    private final String branch;
    private final NavigableMap<Long, Integer> allTimestampsWithCount = new TreeMap<Long, Integer>();
    private final Map<Long, ArrayList<WorkItemChange>> cachedChanges = new HashMap<Long, ArrayList<WorkItemChange>>();
    private int cachedChangesSize = 0;
    private boolean frozen;

    WorkItemChangeCache(TempWorkItemIndex tempWorkItemIndex, String branch) {
        this.tempWorkItemIndex = tempWorkItemIndex;
        this.branch = branch;
    }

    public boolean isEmpty() {
        return this.allTimestampsWithCount.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChanges(Map<Long, ? extends Collection<? extends WorkItemChange>> changes) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            this.validateNotFrozen();
            for (Map.Entry<Long, ? extends Collection<? extends WorkItemChange>> change : changes.entrySet()) {
                this.addChange(change);
            }
            if (this.cachedChangesSize > 100000) {
                this.persistCachedChanges();
            }
        }
    }

    private void addChange(Map.Entry<Long, ? extends Collection<? extends WorkItemChange>> change) throws StorageException {
        Collection<? extends WorkItemChange> changesForTimestamp = change.getValue();
        if (changesForTimestamp.isEmpty()) {
            return;
        }
        long timestamp = change.getKey();
        if (!this.allTimestampsWithCount.containsKey(timestamp)) {
            this.cachedChanges.put(timestamp, new ArrayList<WorkItemChange>(changesForTimestamp));
        } else {
            ArrayList<WorkItemChange> target = this.cachedChanges.get(timestamp);
            if (target == null) {
                target = this.getPersistedChanges(timestamp);
                this.cachedChangesSize += target.size();
                this.cachedChanges.put(timestamp, target);
            }
            target.addAll(changesForTimestamp);
        }
        this.cachedChangesSize += changesForTimestamp.size();
        this.allTimestampsWithCount.merge(timestamp, changesForTimestamp.size(), Integer::sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> getChanges() throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            if (this.anythingWasPersisted()) {
                this.persistCachedChanges();
            }
            return this.getLongSupplierWithExceptionNavigableMap();
        }
    }

    private NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> getLongSupplierWithExceptionNavigableMap() {
        TreeMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> result = new TreeMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>>();
        Iterator iterator = this.allTimestampsWithCount.keySet().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            result.put(timestamp, (SupplierWithException<List<WorkItemChange>, StorageException>)((SupplierWithException)() -> this.getWorkItemChanges(timestamp)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull ArrayList<WorkItemChange> getWorkItemChanges(long timestamp) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            List cached = this.cachedChanges.get(timestamp);
            if (cached != null) {
                return new ArrayList<WorkItemChange>(cached);
            }
            return new ArrayList<WorkItemChange>(this.loadAndPrefetchCache(timestamp));
        }
    }

    private boolean anythingWasPersisted() {
        return this.cachedChanges.size() != this.allTimestampsWithCount.size();
    }

    private List<WorkItemChange> loadAndPrefetchCache(long timestamp) throws StorageException {
        boolean descending = this.shouldPrefetchDescending(timestamp);
        this.cachedChanges.clear();
        this.cachedChangesSize = 0;
        ArrayList<Long> timestampsToFetch = new ArrayList<Long>();
        timestampsToFetch.add(timestamp);
        int elementsToPrefetch = (Integer)this.allTimestampsWithCount.get(timestamp);
        for (Map.Entry possibleTimestampsToPrefetch : this.getNextElementsToPrefetch(timestamp, descending).entrySet()) {
            if (elementsToPrefetch + (Integer)possibleTimestampsToPrefetch.getValue() > 100000) break;
            timestampsToFetch.add((Long)possibleTimestampsToPrefetch.getKey());
            elementsToPrefetch += ((Integer)possibleTimestampsToPrefetch.getValue()).intValue();
        }
        List<ArrayList<WorkItemChange>> persistedChanges = this.getPersistedChanges(timestampsToFetch);
        CollectionUtils.forEach(timestampsToFetch, persistedChanges, (timestamp1, changes) -> {
            this.cachedChanges.put((Long)timestamp1, (ArrayList<WorkItemChange>)changes);
            this.cachedChangesSize += changes.size();
        });
        return this.cachedChanges.get(timestamp);
    }

    private NavigableMap<Long, Integer> getNextElementsToPrefetch(long timestamp, boolean descending) {
        NavigableMap<Long, Integer> timestampWithCountForPrefetch = this.allTimestampsWithCount;
        if (descending) {
            timestampWithCountForPrefetch = this.allTimestampsWithCount.descendingMap();
        }
        return timestampWithCountForPrefetch.tailMap(timestamp, false);
    }

    private boolean shouldPrefetchDescending(long timestamp) {
        if (!this.cachedChanges.isEmpty()) {
            return this.cachedChanges.keySet().iterator().next() > timestamp;
        }
        return this.allTimestampsWithCount.ceilingEntry(timestamp + 1L) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze() {
        Object object = this.lock;
        synchronized (object) {
            this.frozen = true;
        }
    }

    private void validateNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Frozen cache cannot be modified anymore");
        }
    }

    private void persistCachedChanges() throws StorageException {
        this.tempWorkItemIndex.storeChangesForBranch(this.branch, this.cachedChanges);
        this.cachedChanges.clear();
        this.cachedChangesSize = 0;
    }

    private ArrayList<WorkItemChange> getPersistedChanges(long timestamp) throws StorageException {
        return this.tempWorkItemIndex.getChangesForCommit(new CommitDescriptor(this.branch, timestamp));
    }

    private List<ArrayList<WorkItemChange>> getPersistedChanges(List<Long> timestamps) throws StorageException {
        List<CommitDescriptor> commits = timestamps.stream().map(t -> new CommitDescriptor(this.branch, t.longValue())).toList();
        return this.tempWorkItemIndex.getChangesForCommits(commits);
    }
}

