/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import com.teamscale.index.requirements_tracing.index.WorkItemChangeCache;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.conqat.engine.persistence.store.StorageException;

public final class WorkItemChangeCacheFactory {
    static final String CACHE_BRANCH_PREFIX = "__WorkItemChangeCache__";
    private final TempWorkItemIndex tempWorkItemIndex;
    private final String baseBranch = "__WorkItemChangeCache__" + String.valueOf(UUID.randomUUID());
    private final AtomicInteger cacheIndex = new AtomicInteger();

    WorkItemChangeCacheFactory(TempWorkItemIndex tempWorkItemIndex) {
        this.tempWorkItemIndex = tempWorkItemIndex;
    }

    public WorkItemChangeCache createCache() {
        return new WorkItemChangeCache(this.tempWorkItemIndex, this.getNextBranch());
    }

    private String getNextBranch() {
        return this.baseBranch + "_" + this.cacheIndex.getAndIncrement();
    }

    public void clearCaches() throws StorageException {
        this.tempWorkItemIndex.removeChangesForBranch(this.baseBranch);
    }
}

