/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.index;

import com.teamscale.index.requirements_tracing.index.WorkItemChange;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class WorkItemDeletion
extends WorkItemChange {
    private static final long serialVersionUID = 1L;
    private final TeamscaleIssueId workItemId;
    private final long deletionTimestamp;

    public WorkItemDeletion(TeamscaleIssueId workItemId, long deletionTimestamp) {
        this(workItemId, deletionTimestamp, null);
    }

    public WorkItemDeletion(TeamscaleIssueId workItemId, long deletionTimestamp, @Nullable String author) {
        super(WorkItemChange.EType.DELETION, author);
        CCSMAssert.isNotNull((Object)workItemId, () -> String.format("Expected \"%s\" to be not null", "workItemId"));
        this.workItemId = workItemId;
        this.deletionTimestamp = deletionTimestamp;
    }

    @Override
    public TeamscaleIssueId getWorkItemId() {
        return this.workItemId;
    }

    @Override
    public long getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    public String toString() {
        return "WorkItemDeletion{workItemId=" + String.valueOf(this.workItemId) + ", deletionTimestamp=" + this.deletionTimestamp + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkItemDeletion that = (WorkItemDeletion)o;
        return this.deletionTimestamp == that.deletionTimestamp && Objects.equals(this.workItemId, that.workItemId);
    }

    public int hashCode() {
        return Objects.hash(this.workItemId, this.deletionTimestamp);
    }
}

