/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.polarion.alm.ws.client.types.tracker.Change;
import com.polarion.alm.ws.client.types.tracker.FieldDiff;
import com.polarion.alm.ws.client.types.tracker.LinkedWorkItem;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.requirements_tracing.index.SpecItemLatestRevisionCacheIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionExternalElementCache;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.cache.PolarionLatestRevisionCacheSupport;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionImportConfiguration;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.util.PolarionWorkToSpecItemResolvingUtils;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemField;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.concurrent.FutureWithException;
import org.conqat.lib.commons.concurrent.MoreExecutors;
import org.conqat.lib.commons.function.BiConsumerWithTwoExceptions;
import org.jspecify.annotations.NonNull;

public class PolarionWorkItemHistoryProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IssueIndexBase<SpecItem> previousSpecItemIndex;
    private final PolarionLatestRevisionCacheSupport latestRevisionCacheSupport;
    private final PolarionServiceClient polarionClient;
    private final String workItemBaseUrl;
    private final PolarionImportConfiguration configuration;
    private final PolarionExternalElementCache elementCache;
    private final IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<SpecItem> resultBuilder;

    public PolarionWorkItemHistoryProvider(IssueIndexBase<SpecItem> previousSpecItemIndex, SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex, PolarionServiceClient polarionClient, String workItemBaseUrl, PolarionImportConfiguration configuration, PolarionExternalElementCache elementCache, IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<SpecItem> resultBuilder) {
        this.previousSpecItemIndex = previousSpecItemIndex;
        this.elementCache = elementCache;
        this.resultBuilder = resultBuilder;
        this.latestRevisionCacheSupport = new PolarionLatestRevisionCacheSupport(specItemLatestRevisionCacheIndex, configuration.getConnectorId());
        this.polarionClient = polarionClient;
        this.workItemBaseUrl = workItemBaseUrl;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LinkedWorkItemChange> createOrUpdateWorkItemHistories(List<WorkItem> workItems, Map<String, String> possibleStatuses) throws StorageException, InterruptedException {
        ExecutorService executorService = this.buildExecutorService();
        try {
            Map<String, String> latestRevisionById = this.latestRevisionCacheSupport.retrieveLatestKnownRevisions(workItems);
            Set<LinkedWorkItemChange> linkedWorkItemChanges = this.createOrUpdateWorkItemHistories(workItems, possibleStatuses, latestRevisionById, executorService);
            this.latestRevisionCacheSupport.storeLatestKnownRevisions(latestRevisionById);
            Set<LinkedWorkItemChange> set = linkedWorkItemChanges;
            return set;
        }
        finally {
            executorService.shutdown();
        }
    }

    private Set<LinkedWorkItemChange> createOrUpdateWorkItemHistories(List<WorkItem> workItems, Map<String, String> possibleStatuses, Map<String, String> latestRevisionById, ExecutorService executorService) throws InterruptedException, StorageException {
        Map<WorkItemHistoryRetrievalTask, Future<?>> tasks = this.scheduleWorkItemHistoryRetrievalTasks(workItems, latestRevisionById, executorService, possibleStatuses);
        HashSet<LinkedWorkItemChange> additionalChangedWorkItems = new HashSet<LinkedWorkItemChange>();
        for (Map.Entry<WorkItemHistoryRetrievalTask, Future<?>> taskEntry : tasks.entrySet()) {
            WorkItemHistoryRetrievalTask retrievalTask = taskEntry.getKey();
            try {
                taskEntry.getValue().get();
                additionalChangedWorkItems.addAll(retrievalTask.getAdditionalChangedWorkItems());
            }
            catch (ExecutionException e) {
                WorkItem item = retrievalTask.workItem;
                PolarionWorkItemHistoryProvider.handleExecutionException(e, item);
                SpecItem latestItem = PolarionWorkToSpecItemResolvingUtils.buildSpecItem(item, this.configuration.getConnectorId(), possibleStatuses, this.workItemBaseUrl, this.configuration, this.elementCache);
                this.resultBuilder.addItems((PairList<Long, SpecItem>)PairList.from((Object)item.getUpdated().getTimeInMillis(), (Object)latestItem));
            }
            latestRevisionById.put(retrievalTask.workItem.getId(), String.valueOf(retrievalTask.getLatestKnownRevision()));
        }
        return additionalChangedWorkItems;
    }

    private static void handleExecutionException(ExecutionException executionException, WorkItem item) {
        Throwable cause = executionException.getCause();
        String workItemUri = item.getUri();
        if (cause instanceof PolarionServerException) {
            LOGGER.warn("Could not generate history for the work item {}. Skipping to next work item.", (Object)workItemUri, (Object)executionException);
        } else {
            LOGGER.error("Unexpected failure, while generating history for work item {}. Skipping to next work item.", (Object)workItemUri, (Object)executionException);
        }
    }

    private @NonNull Map<WorkItemHistoryRetrievalTask, Future<?>> scheduleWorkItemHistoryRetrievalTasks(List<WorkItem> workItems, Map<String, String> latestRevisionById, ExecutorService executorService, Map<String, String> possibleStatuses) {
        HashMap tasks = new HashMap();
        for (WorkItem item : workItems) {
            WorkItemHistoryRetrievalTask task = new WorkItemHistoryRetrievalTask(this.configuration, this.polarionClient, item, Integer.parseInt(latestRevisionById.getOrDefault(item.getId(), "-1")), (BiConsumerWithTwoExceptions<PairList<WorkItem, String>, List<WorkItem>, InterruptedException, StorageException>)((BiConsumerWithTwoExceptions)(workItemInRevisions, createdWorkItems) -> this.resultBuilder.addItemsWithTimestampAndAuthor(PolarionWorkToSpecItemResolvingUtils.buildSpecItemsWithLastUpdatedTimestamp((PairList<WorkItem, String>)workItemInRevisions, possibleStatuses, this.workItemBaseUrl, this.configuration, createdWorkItems, this.elementCache))));
            tasks.put(task, executorService.submit(task));
        }
        return tasks;
    }

    private ExecutorService buildExecutorService() {
        AtomicInteger threadIndex = new AtomicInteger(0);
        return MoreExecutors.newCachedThreadPool((int)1, (int)PolarionImportConfiguration.MAXIMUM_PARALLELISM, r -> new Thread(r, this.configuration.getConnectorId() + "-polarion-import-worker-" + threadIndex.getAndIncrement()));
    }

    public void generateLinkedWorkItemHistory(Map<String, String> possibleStatuses, Set<TeamscaleIssueId> updatedSpecItemIds, Set<LinkedWorkItemChange> additionalChangedWorkItems) throws StorageException, InterruptedException {
        Map<LinkedWorkItemChange, FutureWithException<WorkItem, PolarionServerException>> itemsInRevision = this.scheduleAdditionChangedWorkItemRetrievals(additionalChangedWorkItems);
        PairList workItems = new PairList(itemsInRevision.size());
        for (Map.Entry<LinkedWorkItemChange, FutureWithException<WorkItem, PolarionServerException>> entry : itemsInRevision.entrySet()) {
            LinkedWorkItemChange additionalChangedWorkItem = entry.getKey();
            try {
                WorkItem itemInRevision = (WorkItem)entry.getValue().getWithException();
                TeamscaleIssueId linkedItemId = new TeamscaleIssueId(this.configuration.getConnectorId(), itemInRevision.getId());
                if (!updatedSpecItemIds.contains(linkedItemId) && this.previousSpecItemIndex.getIssue(linkedItemId) == null) continue;
                itemInRevision.getUpdated().setTimeInMillis(additionalChangedWorkItem.changeTimestamp().toEpochMilli());
                workItems.add((Object)itemInRevision, (Object)additionalChangedWorkItem.changeAuthor);
            }
            catch (PolarionServerException | RuntimeException e) {
                LOGGER.warn("Could not generate work item history for linked work item {}, link will only be visible once the item was updated", (Object)additionalChangedWorkItem.workItemUri());
            }
        }
        this.resultBuilder.addItemsWithTimestampAndAuthor(PolarionWorkToSpecItemResolvingUtils.buildSpecItemsWithLastUpdatedTimestamp((PairList<WorkItem, String>)workItems, possibleStatuses, this.workItemBaseUrl, this.configuration, Collections.emptyList(), this.elementCache));
    }

    private @NonNull Map<LinkedWorkItemChange, FutureWithException<WorkItem, PolarionServerException>> scheduleAdditionChangedWorkItemRetrievals(Set<LinkedWorkItemChange> additionalChangedWorkItems) {
        HashMap<LinkedWorkItemChange, FutureWithException<WorkItem, PolarionServerException>> itemsInRevision = new HashMap<LinkedWorkItemChange, FutureWithException<WorkItem, PolarionServerException>>();
        for (LinkedWorkItemChange additionalChangedWorkItem : additionalChangedWorkItems) {
            itemsInRevision.computeIfAbsent(additionalChangedWorkItem, ignored -> this.polarionClient.getWorkItemInRevision(additionalChangedWorkItem.workItemUri(), additionalChangedWorkItem.revision(), this.configuration.getAllFieldIdsToBeFetched()));
        }
        return itemsInRevision;
    }

    private static class WorkItemHistoryRetrievalTask
    implements Callable<Void> {
        private final PolarionImportConfiguration configuration;
        private final PolarionServiceClient polarionClient;
        private final WorkItem workItem;
        private int latestKnownRevision;
        private final Set<LinkedWorkItemChange> additionalChangedWorkItems = new HashSet<LinkedWorkItemChange>();
        private final BiConsumerWithTwoExceptions<PairList<WorkItem, String>, List<WorkItem>, InterruptedException, StorageException> resultConsumer;

        private WorkItemHistoryRetrievalTask(PolarionImportConfiguration configuration, PolarionServiceClient polarionClient, WorkItem workItem, int latestKnownRevision, BiConsumerWithTwoExceptions<PairList<WorkItem, String>, List<WorkItem>, InterruptedException, StorageException> resultConsumer) {
            this.configuration = configuration;
            this.polarionClient = polarionClient;
            this.workItem = workItem;
            this.latestKnownRevision = latestKnownRevision;
            this.resultConsumer = resultConsumer;
        }

        @Override
        public synchronized Void call() throws InterruptedException, PolarionServerException, StorageException {
            String workItemUri = this.workItem.getUri();
            List<Change> workItemHistory = this.getWorkItemHistory(workItemUri);
            Map<Change, FutureWithException<WorkItem, PolarionServerException>> openRequests = this.getWorkItemsForChange(workItemHistory, workItemUri);
            PairList workItemInRevisions = new PairList();
            ArrayList<WorkItem> createdWorkItems = new ArrayList<WorkItem>();
            this.collectWorkItemRevisions(openRequests, (PairList<WorkItem, String>)workItemInRevisions, createdWorkItems);
            if (this.latestKnownRevision < 0 && !workItemHistory.isEmpty()) {
                Change latestChange = Objects.requireNonNull((Change)CollectionUtils.getLast(workItemHistory));
                workItemInRevisions.add((Object)this.workItem, (Object)latestChange.getUser());
                this.latestKnownRevision = Integer.parseInt(latestChange.getRevision());
            }
            this.ensureLatestRevisionIsPresent(this.workItem, (PairList<WorkItem, String>)workItemInRevisions);
            this.resultConsumer.accept((Object)workItemInRevisions, createdWorkItems);
            return null;
        }

        private List<Change> getWorkItemHistory(String workItemUri) throws InterruptedException, PolarionServerException {
            return (List)this.polarionClient.getWorkItemChangeHistory(workItemUri, (Set<String>)this.configuration.getCustomFieldConfiguration().getIgnoredFields()).getWithException();
        }

        private Map<Change, FutureWithException<WorkItem, PolarionServerException>> getWorkItemsForChange(List<Change> changes, String workItemUri) {
            LinkedHashMap<Change, FutureWithException<WorkItem, PolarionServerException>> openRequests = new LinkedHashMap<Change, FutureWithException<WorkItem, PolarionServerException>>();
            for (Change change : changes) {
                if (this.shouldSkipChange(this.latestKnownRevision, change)) continue;
                openRequests.put(change, this.polarionClient.getWorkItemInRevision(workItemUri, change.getRevision(), this.configuration.getAllFieldIdsToBeFetched()));
                this.investigateFieldChanges(change);
            }
            return openRequests;
        }

        private void collectWorkItemRevisions(Map<Change, FutureWithException<WorkItem, PolarionServerException>> openRequests, PairList<WorkItem, String> workItemInRevisions, List<WorkItem> createdWorkItems) throws InterruptedException, PolarionServerException {
            for (Map.Entry<Change, FutureWithException<WorkItem, PolarionServerException>> openRequest : openRequests.entrySet()) {
                Change change = openRequest.getKey();
                WorkItem workItemInRevision = (WorkItem)openRequest.getValue().getWithException();
                workItemInRevisions.add((Object)workItemInRevision, (Object)change.getUser());
                if (change.isCreation()) {
                    createdWorkItems.add(workItemInRevision);
                }
                this.latestKnownRevision = Integer.parseInt(change.getRevision());
            }
        }

        private boolean shouldSkipChange(int latestKnownRevision, Change change) {
            return latestKnownRevision >= Integer.parseInt(change.getRevision()) || change.getDate().getTime().toInstant().isBefore(this.configuration.getInitialTimestamp());
        }

        private void investigateFieldChanges(Change change) {
            for (FieldDiff diff : change.getDiffs()) {
                if (!EPolarionDefaultWorkItemField.LINKED_WORK_ITEMS.getPolarionFieldName().equals(diff.getFieldName())) continue;
                Stream.of(diff.getAdded(), diff.getRemoved()).flatMap(Arrays::stream).filter(LinkedWorkItem.class::isInstance).map(LinkedWorkItem.class::cast).filter(linkedWorkItem -> this.configuration.getResolvedIncludedPolarionWorkItemLinkRoles().containsKey((Object)linkedWorkItem.getRole().getId())).map(LinkedWorkItem::getWorkItemURI).map(wiu -> new LinkedWorkItemChange((String)wiu, change.getRevision(), change.getDate().toInstant(), change.getUser())).forEach(this.additionalChangedWorkItems::add);
            }
        }

        private void ensureLatestRevisionIsPresent(WorkItem workItem, PairList<WorkItem, String> workItemInRevisions) {
            if (workItemInRevisions.isEmpty() || Objects.requireNonNull((WorkItem)CollectionUtils.getLast((List)workItemInRevisions.getFirstList())).getUpdated().before(workItem.getUpdated())) {
                workItemInRevisions.add((Object)workItem, null);
            }
        }

        private synchronized int getLatestKnownRevision() {
            return this.latestKnownRevision;
        }

        private synchronized Set<LinkedWorkItemChange> getAdditionalChangedWorkItems() {
            return this.additionalChangedWorkItems;
        }
    }

    public record LinkedWorkItemChange(String workItemUri, String revision, Instant changeTimestamp, String changeAuthor) {
    }
}

