/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.triggers.polarion;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.index.issues.cleanup.NoOpCleanupStrategy;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemLinkRoleIndex;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemTypeIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemLatestRevisionCacheIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionSessionException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionFieldsImporter;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionImportConfiguration;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionWorkItemImporter;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import com.teamscale.wia.ExternalToolIssueCustomField;
import com.teamscale.wia.SpecItem;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK, EAnalysisStepParameter.LIMIT_CONCURRENT_EXECUTIONS}, concurrencyLimit=@AnalysisStep.ConcurrencyLimit(maxConcurrency=-1, maxConcurrencyProperty="com.teamscale.polarion.synchronizer_concurrency_limit"))
public class PolarionSynchronizer
extends IssueTrackerSynchronizerBase<SpecItem> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CLEANUP_ENABLED_PARAMETER = "cleanup-enabled";
    public static final String WORK_ITEM_LINK_PATTERN_PARAMETER_NAME = "workItemLinkPattern";
    public static final String WORK_ITEM_ID_GROUP_NAME = "workItemId";
    public static final String DEFAULT_WORK_ITEM_LINK_PATTERN = "id=\"polarion_wiki macro name=module-workitem;params=((id=(?<workItemId>[^\"|]+))|[^\"])+\"";
    @VisibleForTesting
    static final String MAXIMUM_PARALLELISM_PARAMETER = "maximumParallelism";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SpecItemHistoryIndex specItemHistoryIndex;
    @StepParameterObject
    private final PolarionDocumentLocation polarionDocumentLocation = new PolarionDocumentLocation();
    @StepParameter(value="Included work item types")
    private PairList<String, String> includedWorkItemTypes = new PairList();
    @StepParameter(value="Included work item link roles", optional=true)
    private List<String> includedWorkItemLinkRoles = new ArrayList<String>();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    protected SpecItemIndex previousIssueIndex;
    @StepParameter(value="custom-fields", optional=true)
    private List<String> includedCustomFieldIds = new ArrayList<String>();
    @StepParameter(value="workItemLinkPattern", optional=true)
    private String workItemLinkPattern = "id=\"polarion_wiki macro name=module-workitem;params=((id=(?<workItemId>[^\"|]+))|[^\"])+\"";
    @StepParameter(value="cleanup-enabled", optional=true)
    protected boolean cleanupEnabled = false;
    @StepParameterObject
    private final OnceEveryDayCleanupStrategy baseCleanupStrategy = new OnceEveryDayCleanupStrategy();
    @StepParameter(value="maximumParallelism", optional=true)
    private int maximumParallelism = PolarionImportConfiguration.MAXIMUM_PARALLELISM;
    private IWorkItemCleanupStrategy resolvedCleanupStrategy;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PolarionWorkItemLinkRoleIndex polarionWorkItemLinkRoleIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PolarionWorkItemTypeIndex polarionWorkItemTypeIndex;

    @Override
    protected void init() throws BugTrackerException {
        this.initCleanupStrategy();
    }

    private void initCleanupStrategy() {
        this.resolvedCleanupStrategy = this.cleanupEnabled ? this.baseCleanupStrategy : new NoOpCleanupStrategy();
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws StorageException {
        IssueTrackerSynchronizerBase.WorkItemUpdateResult workItemUpdateResult;
        PolarionServiceClient polarionClient = new PolarionServiceClient(this.connectorId, new PolarionServiceClient.Credentials(this.getUrl(), this.getUsername(), this.getPassword()), this.maximumParallelism);
        try {
            PolarionFieldsImporter fieldsImporter = new PolarionFieldsImporter(this.polarionDocumentLocation.getProjectId(), polarionClient);
            List<PolarionWorkItemType> workItemTypes = fieldsImporter.retrieveIncludedPolarionWorkItemTypes(this.polarionWorkItemTypeIndex, this.includedWorkItemTypes);
            TwoDimHashMap<String, String, ExternalToolIssueCustomField> customFields = fieldsImporter.retrieveCustomFieldDefinitions(this.includedWorkItemTypes.extractFirstList());
            List<PolarionWorkItemLinkRole> workItemLinkRoles = fieldsImporter.retrieveAndStorePolarionWorkItemLinkRoles(this.polarionWorkItemLinkRoleIndex, false);
            PolarionImportConfiguration configuration = new PolarionImportConfiguration(this.polarionDocumentLocation, polarionClient, workItemTypes, new PolarionImportConfiguration.CustomFieldConfiguration(customFields, this.includedCustomFieldIds), workItemLinkRoles, this.includedWorkItemLinkRoles, this.connectorId, Instant.ofEpochMilli(startTimestamp), Pattern.compile(this.workItemLinkPattern), this.resolvedCleanupStrategy);
            IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<SpecItem> resultBuilder = this.resultBuilder();
            PolarionWorkItemImporter importer = new PolarionWorkItemImporter(configuration, this.getCurrentImportStart(), resultBuilder);
            importer.importWorkItems(this.previousIssueIndex, this.specItemLatestRevisionCacheIndex, Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp));
            workItemUpdateResult = resultBuilder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    polarionClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PolarionServerException | PolarionSessionException | InterruptedException ex) {
                LOGGER.error("Failed to import specification items: " + ex.getMessage(), (Throwable)ex);
                return this.resultBuilder().build();
            }
        }
        polarionClient.close();
        return workItemUpdateResult;
    }

    @Override
    protected IssueIndexBase<SpecItem> getWorkItemIndex() {
        return this.previousIssueIndex;
    }

    @Override
    protected IIssueHistoryIndex<SpecItem> getIssueHistoryIndex() {
        return this.specItemHistoryIndex;
    }
}

