/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.dependencies.NearestNeighborFileDependencyFilteringStrategy;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.IncludedTokens;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

public class FileIncludeLookup {
    private final IMatchingPathsLookup pathsLookup;
    private final SystemIncludeFileLookup systemIncludeFileLookup;

    public FileIncludeLookup(IMatchingPathsLookup pathLookupIndex, SystemIncludeFileLookup systemIncludeFileLookup) {
        this.pathsLookup = Objects.requireNonNull(pathLookupIndex);
        this.systemIncludeFileLookup = Objects.requireNonNull(systemIncludeFileLookup);
    }

    public Optional<String> resolveIncludeToUniformPath(IncludeDirective includeDirective, String includingUniformPath, List<String> includeSearchPaths) {
        return this.resolveIncludeToUniformPath(includeDirective.getIncludedFilePath(), includingUniformPath, includeSearchPaths, includeDirective.isIncludeNext(), includeDirective.isUsingQuotes());
    }

    public Optional<String> resolveIncludeToUniformPath(String includedFilePath, String includingUniformPath) {
        return this.resolveIncludeToUniformPath(includedFilePath, includingUniformPath, Collections.emptyList(), false, true);
    }

    private Optional<String> resolveIncludeToUniformPath(String includedFilePath, String includingUniformPath, List<String> includeSearchPaths, boolean includeNextSemantics, boolean searchRelativeToIncludingPath) {
        CStandardLookupStrategy cStandardLookupStrategy = new CStandardLookupStrategy(this, includeSearchPaths, false, true, includeNextSemantics);
        Optional<String> uniformPath = cStandardLookupStrategy.resolveIncludedFilePath(includedFilePath, includingUniformPath);
        if (uniformPath.isPresent()) {
            return uniformPath;
        }
        HeuristicLookupStrategy heuristicLookupStrategy = new HeuristicLookupStrategy(this, includeNextSemantics, searchRelativeToIncludingPath);
        return heuristicLookupStrategy.resolveIncludedFilePath(includedFilePath, includingUniformPath);
    }

    public Optional<String> resolveIncludeToUniformPathWithCStandardLookup(IncludeDirective includeDirective, String includingUniformPath, List<String> includeSearchPaths, boolean caseSensitive) {
        CStandardLookupStrategy cStandardLookupStrategy = new CStandardLookupStrategy(this, includeSearchPaths, caseSensitive, includeDirective.isUsingQuotes(), includeDirective.isIncludeNext());
        return cStandardLookupStrategy.resolveIncludedFilePath(includeDirective.getIncludedFilePath(), includingUniformPath);
    }

    public Optional<String> resolveIncludeToUniformPathWithHeuristic(IncludeDirective includeDirective, String includingUniformPath) {
        HeuristicLookupStrategy heuristicLookupStrategy = new HeuristicLookupStrategy(this, includeDirective.isIncludeNext(), includeDirective.isUsingQuotes());
        return heuristicLookupStrategy.resolveIncludedFilePath(includeDirective.getIncludedFilePath(), includingUniformPath);
    }

    public SystemIncludeFileLookup getSystemIncludeFileLookup() {
        return this.systemIncludeFileLookup;
    }

    private class CStandardLookupStrategy
    extends IncludeLookupStrategyBase {
        private final List<String> includeSearchPaths;
        private final boolean caseSensitive;
        private final boolean searchRelativeToIncludingPath;
        private final boolean includeNextSemantics;
        final /* synthetic */ FileIncludeLookup this$0;

        private CStandardLookupStrategy(FileIncludeLookup fileIncludeLookup, List<String> includeSearchPaths, boolean caseSensitive, boolean searchRelativeToIncludingPath, boolean includeNextSemantics) {
            FileIncludeLookup fileIncludeLookup2 = fileIncludeLookup;
            Objects.requireNonNull(fileIncludeLookup2);
            this.this$0 = fileIncludeLookup2;
            super(fileIncludeLookup);
            this.includeSearchPaths = Objects.requireNonNull(includeSearchPaths);
            this.caseSensitive = caseSensitive;
            this.searchRelativeToIncludingPath = searchRelativeToIncludingPath;
            this.includeNextSemantics = includeNextSemantics;
        }

        private Optional<String> resolveIncludedFilePath(String includedFilePath, String includingUniformPath) {
            String candidate;
            Optional<String> uniformPath;
            String normalizedIncludedFilePath = UniformPathUtils.normalizeAllSeparators((String)includedFilePath);
            if (this.searchRelativeToIncludingPath && !this.includeNextSemantics && (uniformPath = this.findCompletePath(candidate = UniformPathUtils.resolveRelativePath((String)includingUniformPath, (String)normalizedIncludedFilePath), this.caseSensitive)).isPresent()) {
                return uniformPath;
            }
            for (String includeSearchPath : this.includeSearchPaths) {
                String path = CStandardLookupStrategy.buildIncludedFilePath(includeSearchPath, normalizedIncludedFilePath);
                if (this.includeNextSemantics && path.startsWith(UniformPathUtils.getParentPath((String)includingUniformPath))) continue;
                Optional<String> uniformPath2 = this.findCompletePath(path, this.caseSensitive);
                if (uniformPath2.isPresent()) {
                    return uniformPath2;
                }
                uniformPath2 = this.tryResolveSystemIncludeToUniformPath(path);
                if (!uniformPath2.isPresent()) continue;
                return uniformPath2;
            }
            return Optional.empty();
        }

        private static String buildIncludedFilePath(String includeSearchPath, String normalizedIncludedFilePath) {
            boolean startsWithLeadingSlash = includeSearchPath.startsWith("/");
            String normalizedIncludeSearchPath = UniformPathUtils.cleanPath((String)UniformPathUtils.normalizeAllSeparators((String)includeSearchPath));
            String path = normalizedIncludeSearchPath + UniformPathUtils.SEPARATOR + normalizedIncludedFilePath;
            if (startsWithLeadingSlash) {
                return UniformPathUtils.SEPARATOR + path;
            }
            return path;
        }

        private Optional<String> tryResolveSystemIncludeToUniformPath(String uniformPath) {
            Optional<IncludedTokens> includedTokens = this.this$0.systemIncludeFileLookup.readSystemIncludeTokens(uniformPath);
            return includedTokens.map(tokens -> tokens.includedFileUniformPath);
        }
    }

    private class HeuristicLookupStrategy
    extends IncludeLookupStrategyBase {
        private final boolean includeNextSemantics;
        private final boolean searchRelativeToIncludingPath;
        final /* synthetic */ FileIncludeLookup this$0;

        private HeuristicLookupStrategy(FileIncludeLookup fileIncludeLookup, boolean includeNextSemantics, boolean searchRelativeToIncludingPath) {
            FileIncludeLookup fileIncludeLookup2 = fileIncludeLookup;
            Objects.requireNonNull(fileIncludeLookup2);
            this.this$0 = fileIncludeLookup2;
            super(fileIncludeLookup);
            this.includeNextSemantics = includeNextSemantics;
            this.searchRelativeToIncludingPath = searchRelativeToIncludingPath;
        }

        private Optional<String> resolveIncludedFilePath(String includedFilePath, String includingUniformPath) {
            ImmutableList<String> candidatePaths;
            String normalizedIncludedFilePath = UniformPathUtils.normalizeAllSeparators((String)includedFilePath);
            String expectedPath = this.searchRelativeToIncludingPath ? UniformPathUtils.resolveRelativePath((String)includingUniformPath, (String)normalizedIncludedFilePath) : includedFilePath;
            Optional<String> bestMatch = HeuristicLookupStrategy.pickBestMatch(expectedPath, candidatePaths = this.this$0.pathsLookup.lookupAllPaths(includedFilePath, PathLookupOptions.includePathsWhereOnlyFileNameMatches()));
            if (bestMatch.isEmpty() || !this.includeNextSemantics) {
                return bestMatch;
            }
            List candidatePathsWithoutBestPath = CollectionUtils.filter(candidatePaths, path -> !path.equals(bestMatch.get()));
            return HeuristicLookupStrategy.pickBestMatch(expectedPath, candidatePathsWithoutBestPath);
        }

        private static Optional<String> pickBestMatch(String uniformPath, Collection<String> candidates) {
            if (candidates.isEmpty()) {
                return Optional.empty();
            }
            String nearestPath = NearestNeighborFileDependencyFilteringStrategy.getNearestPath(uniformPath, candidates);
            return Optional.of(nearestPath);
        }
    }

    private abstract class IncludeLookupStrategyBase {
        final /* synthetic */ FileIncludeLookup this$0;

        private IncludeLookupStrategyBase(FileIncludeLookup fileIncludeLookup) {
            FileIncludeLookup fileIncludeLookup2 = fileIncludeLookup;
            Objects.requireNonNull(fileIncludeLookup2);
            this.this$0 = fileIncludeLookup2;
        }

        protected Optional<String> findCompletePath(String candidate, boolean caseSensitive) {
            if (caseSensitive) {
                return this.this$0.pathsLookup.lookupSuffix(candidate).stream().filter(candidate::equals).findFirst();
            }
            return this.this$0.pathsLookup.lookupSuffix(candidate).stream().filter(candidate::equalsIgnoreCase).findFirst();
        }
    }
}

