/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Index(name="report-partition-origin", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={ReportPartitionOrigin.class})
public class ReportPartitionOriginIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "report-partition-origin";
    private static final Logger LOGGER = LogManager.getLogger();
    private final IStore store;
    private final IStorageAbbreviator abbreviator;

    public ReportPartitionOriginIndex(IStore store) {
        this.store = store;
        this.abbreviator = ((IAbbreviationStoreCapability)store.getCapability(IAbbreviationStoreCapability.class).orElseThrow()).abbreviator();
    }

    public void storePartitionOrigins(Set<ReportPartitionOrigin> reportPartitionOrigins) throws StorageException {
        if (reportPartitionOrigins.isEmpty()) {
            return;
        }
        PairList newEntries = new PairList();
        for (ReportPartitionOrigin reportPartitionOrigin : reportPartitionOrigins) {
            if (reportPartitionOrigin == null) continue;
            byte[] key = this.createKey(reportPartitionOrigin);
            byte[] value = ReportPartitionOriginIndex.serializeValue(reportPartitionOrigin);
            newEntries.add((Object)key, (Object)value);
        }
        PairList<byte[], byte[]> entriesToWrite = this.collectEntriesToWrite((PairList<byte[], byte[]>)newEntries);
        if (!entriesToWrite.isEmpty()) {
            this.store.put(entriesToWrite);
            ReportPartitionOriginIndex.logWrittenEntries(entriesToWrite);
        }
    }

    private static void logWrittenEntries(PairList<byte[], byte[]> entriesToWrite) {
        LOGGER.trace("Wrote new entries: [{}]", new Supplier[]{() -> {
            try {
                return ReportPartitionOriginIndex.deserializeEntries(entriesToWrite);
            }
            catch (Exception e) {
                return e;
            }
        }});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NullMarked
    private PairList<byte[], byte[]> collectEntriesToWrite(PairList<byte[], byte[]> newEntries) throws StorageException {
        @Nullable List oldValues = this.store.get((List)newEntries.getFirstList());
        PairList keysValuesToWrite = new PairList();
        for (int i = 0; i < oldValues.size(); ++i) {
            byte[] newValue;
            byte[] oldValue = (byte[])oldValues.get(i);
            if (Arrays.equals(oldValue, newValue = (byte[])newEntries.getSecond(i))) continue;
            if (oldValue != null) {
                ReportPartitionOriginIndex.logWarningForPartitionOriginOverwrite(newValue, oldValue);
            }
            keysValuesToWrite.add((Object)((byte[])newEntries.getFirst(i)), (Object)newValue);
        }
        return keysValuesToWrite;
    }

    @NullMarked
    private static void logWarningForPartitionOriginOverwrite(byte[] newPartitionOrigin, byte[] oldPartitionOrigin) throws StorageException {
        try {
            ReportPartitionOrigin newValue = ReportPartitionOriginIndex.deserializeValue(newPartitionOrigin);
            ReportPartitionOrigin oldValue = ReportPartitionOriginIndex.deserializeValue(oldPartitionOrigin);
            LOGGER.warn("Overwriting partition origin for partition {}. Previously this partition was imported from connector {}. Now it is imported from connector {}. This should happen only when you moved reports from one connector to another one (i.e., at special points in the project history). If it happens frequently, this might lead to unexpected results.", (Object)newValue.partitionName, (Object)oldValue.originConnectorId, (Object)newValue.originConnectorId);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static byte[] serializeValue(ReportPartitionOrigin reportPartitionOrigin) throws StorageException {
        try {
            return SerializationUtils.serializeToByteArray((Serializable)reportPartitionOrigin);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static @NonNull ReportPartitionOrigin deserializeValue(byte @NonNull [] serializedOrigin) throws IOException, ClassNotFoundException {
        return (ReportPartitionOrigin)SerializationUtils.deserializeFromByteArray((byte[])serializedOrigin);
    }

    private byte[] createKey(ReportPartitionOrigin reportPartitionOrigin) throws StorageException {
        return this.abbreviator.abbreviate(reportPartitionOrigin.partitionName).toByteArray();
    }

    public Map<String, ReportPartitionOrigin> loadAllPartitionOrigins() throws StorageException {
        EntryMessage entryMessage = LOGGER.traceEntry("Loading partition origins.", new Supplier[0]);
        try {
            PairList resultList = new PairList();
            this.store.scan(new byte[0], (IKeyValueCallback)new KeyValueCollectingCallback(resultList));
            return (Map)LOGGER.traceExit(entryMessage, ReportPartitionOriginIndex.deserializeEntries((PairList<byte[], byte[]>)resultList));
        }
        catch (Exception e) {
            throw (StorageException)((Object)LOGGER.traceExit(entryMessage, (Object)new StorageException((Throwable)e)));
        }
    }

    private static @NonNull Map<String, ReportPartitionOrigin> deserializeEntries(PairList<byte[], byte[]> resultList) throws IOException, ClassNotFoundException {
        HashMap<String, ReportPartitionOrigin> deserializedResults = new HashMap<String, ReportPartitionOrigin>();
        for (byte[] serializedOrigin : resultList.getSecondList()) {
            ReportPartitionOrigin reportPartitionOrigin = ReportPartitionOriginIndex.deserializeValue(serializedOrigin);
            deserializedResults.put(reportPartitionOrigin.partitionName, reportPartitionOrigin);
        }
        return deserializedResults;
    }

    @IndexValueClass
    public record ReportPartitionOrigin(@NonNull String partitionName, String originConnectorId, ERepositoryConnector connectorType, EReportDeletionBehavior reportDeletionBehavior) implements Serializable
    {
    }

    @IndexValueClass
    public static enum EReportDeletionBehavior {
        IGNORE_REPORT_DELETION_IN_PARTITION_WITHOUT_ADDITIONS_OR_CHANGES,
        REMOVE_ALL_DELETED_REPORTS;

    }
}

