/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.architecture;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.VirtualFileSystemContainerIndexSynchronizerBase;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureContainerIndexSynchronizer
extends VirtualFileSystemContainerIndexSynchronizerBase {
    @DeltaSource.Named(index=MetricsIndex.class, name="architecture-metrics")
    private KeyDelta architectureMetricsDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="architecture-metrics")
    private MetricsIndex architectureMetricsIndex;

    @Override
    protected MetricsIndex getMetricsIndex() {
        return this.architectureMetricsIndex;
    }

    @Override
    protected KeyDelta getMetricsDelta() {
        return this.architectureMetricsDelta;
    }

    @Override
    protected String cleanKey(String key) {
        return ArchitectureMetricsUtils.removeArchitecturePathPrefix(key);
    }
}

