/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.architecture;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ArchitectureMetricsIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final int METRICS_COPY_BATCH_SIZE = 1000;
    private final List<String> metricPartitionNames = new ArrayList<String>();
    private final List<byte[]> metricPartitionDefaultValues = new ArrayList<byte[]>();
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="metrics")
    private MetricsIndex metricsIndex;
    @DeltaSource.Named(index=MetricsIndex.class, name="metrics")
    private KeyDelta metricsDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="architecture-metrics")
    private MetricsIndex architectureMetricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsIndex;
    @DeltaSource(value=MetricsToArchitectureMetricsMappingIndex.class)
    private KeyDelta metricsToArchitectureMetricsDelta;

    public void execute() throws StorageException {
        this.fillPartitionDataLists();
        if (!this.metricsToArchitectureMetricsDelta.getDeletedKeys().isEmpty()) {
            this.removeDeletedArchitecturePathMetrics();
        }
        if (!this.metricsDelta.getDeletedKeys().isEmpty()) {
            this.removeOutdatedEntries((List<StorageKey>)this.metricsDelta.getDeletedKeys());
        }
        this.updateEntries();
    }

    private void fillPartitionDataLists() throws StorageException {
        List metricSources = this.metricSchemaIndex.getMetricSources();
        MetricDirectorySchema schema = this.metricSchemaIndex.getSchema(false);
        for (int i = 0; i < metricSources.size(); ++i) {
            if (!(metricSources.get(i) instanceof IndexMetricSource)) continue;
            this.metricPartitionNames.add(((IndexMetricSource)metricSources.get(i)).getMetricPartition());
            byte[] defaultValue = StorageUtils.serializeCompactObject((Object)schema.getEntry(i).getValueType().getDefaultValue());
            this.metricPartitionDefaultValues.add(defaultValue);
        }
    }

    private void removeDeletedArchitecturePathMetrics() throws StorageException {
        List architecturePathsToDelete = CollectionUtils.filterAndMap((Collection)this.metricsToArchitectureMetricsDelta.getDeletedKeysAsStrings(), ArchitectureMetricsUtils::isArchitectureArtifactPath, key -> ArchitectureMetricsIndexSynchronizer.stripNoMappingSuffix(MetricsToArchitectureMetricsMappingIndex.splitMapping(key)[0]));
        this.architectureMetricsIndex.removeEntries((Collection)architecturePathsToDelete, this.metricPartitionNames);
    }

    private void removeOutdatedEntries(List<StorageKey> deletedMetricKeys) throws StorageException {
        ArrayList<String> unabrreviatedKeys = new ArrayList<String>(this.metricsIndex.rawIndexKeysToUniformPaths(CollectionUtils.map(deletedMetricKeys, StorageKey::getKey)));
        List<String> mappingKeys = this.metricsToArchitectureMetricsIndex.getMappingsStartingWith(unabrreviatedKeys);
        List architecturePaths = CollectionUtils.map(mappingKeys, key -> MetricsToArchitectureMetricsMappingIndex.splitMapping(key)[1]);
        this.architectureMetricsIndex.removeEntries((Collection)architecturePaths, this.metricPartitionNames);
    }

    private void updateEntries() throws StorageException {
        Set addedOrChangedKeys = this.architectureMetricsIndex.rawIndexKeysToUniformPaths(this.metricsDelta.getAddedOrChangedKeysAsBytes());
        List architectureMetricPaths = CollectionUtils.filterAndMap((Collection)this.metricsToArchitectureMetricsDelta.getAddedOrChangedKeysAsStrings(), ArchitectureMetricsUtils::isArchitectureArtifactPath, ArchitectureMetricsIndexSynchronizer::extractMetricPath);
        addedOrChangedKeys.addAll(architectureMetricPaths);
        ArrayList<String> changedKeys = new ArrayList<String>(addedOrChangedKeys);
        List<byte[]> metrics = this.getMetricValues(changedKeys);
        List<List<String>> mappings = this.getMappingForKeys(changedKeys);
        PairList values = new PairList();
        for (int partitionIndex = 0; partitionIndex < this.metricPartitionNames.size(); ++partitionIndex) {
            List<String> partitionAsList = Collections.singletonList(this.metricPartitionNames.get(partitionIndex));
            for (int keyIndex = 0; keyIndex < changedKeys.size(); ++keyIndex) {
                List<String> mappedPaths = mappings.get(keyIndex);
                if (mappedPaths == null) continue;
                byte[] rawMetricValue = this.getRawMetricValue(changedKeys, metrics, partitionIndex, keyIndex);
                List indexKeys = this.metricsIndex.createRawKeys((Collection)CollectionUtils.map(mappedPaths, ArchitectureMetricsIndexSynchronizer::stripNoMappingSuffix), partitionAsList);
                indexKeys.forEach(key -> values.add(key, (Object)rawMetricValue));
            }
            this.writeMappingToStoreIfNecessary((PairList<byte[], byte[]>)values, false);
        }
        this.writeMappingToStoreIfNecessary((PairList<byte[], byte[]>)values, true);
    }

    private void writeMappingToStoreIfNecessary(PairList<byte[], byte[]> keyValueMapping, boolean forceWrite) throws StorageException {
        if (forceWrite || keyValueMapping.size() > 1000) {
            this.architectureMetricsIndex.setRawMetricValues(keyValueMapping);
            keyValueMapping.clear();
        }
    }

    private static String extractMetricPath(String key) {
        return ArchitectureMetricsUtils.removeArchitecturePathPrefix(MetricsToArchitectureMetricsMappingIndex.splitMapping(key)[0]);
    }

    private static String stripNoMappingSuffix(String path) {
        if (path.contains("--NO_MAPPING--")) {
            return path.split("/-src-/")[0] + "/";
        }
        return path;
    }

    private List<byte[]> getMetricValues(List<String> addedOrChangedKeys) throws StorageException {
        PairList partitionAndPaths = new PairList();
        for (String partition : this.metricPartitionNames) {
            for (String key : addedOrChangedKeys) {
                partitionAndPaths.add((Object)partition, (Object)key);
            }
        }
        return this.metricsIndex.getRawMetricValues(partitionAndPaths);
    }

    private List<List<String>> getMappingForKeys(List<String> metricKeys) throws StorageException {
        ArrayList<List<String>> mapping = new ArrayList<List<String>>();
        for (String key : metricKeys) {
            List<String> combinedKeys = this.metricsToArchitectureMetricsIndex.getMappingsStartingWith(key + "<-sep->");
            mapping.add(CollectionUtils.map(combinedKeys, combinedKey -> MetricsToArchitectureMetricsMappingIndex.splitMapping(combinedKey)[1]));
        }
        return mapping;
    }

    private byte[] getRawMetricValue(List<String> changedKeys, List<byte[]> metrics, int partitionIndex, int keyIndex) {
        byte[] metric = metrics.get(partitionIndex * changedKeys.size() + keyIndex);
        if (metric == null) {
            return this.metricPartitionDefaultValues.get(partitionIndex);
        }
        return metric;
    }
}

