/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.IPathLookupIndex;
import com.teamscale.index.resource.path_lookup.LongestMatchingSuffixPathsCollector;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.tree.Trie;
import org.jspecify.annotations.NonNull;

public class PreloadedMatchingPathsLookup
implements IMatchingPathsLookup {
    private final double pathSuffixSizeRatioThreshold;
    private final Trie<ImmutableList<String>> pathsByNormalizedReversedPaths = new Trie();
    private final ConcurrentMap<String, Optional<Pair<String, ImmutableList<String>>>> lookupResultsByNormalizedReversedPaths = new ConcurrentHashMap<String, Optional<Pair<String, ImmutableList<String>>>>();
    private final ConcurrentMap<String, Optional<String>> lookupPathBestMatchCache = new ConcurrentHashMap<String, Optional<String>>();
    private final ConcurrentMap<String, ImmutableList<String>> lookupAllPathsCache = new ConcurrentHashMap<String, ImmutableList<String>>();

    private PreloadedMatchingPathsLookup(IPathLookupIndex pathLookupIndex, double pathSuffixSizeRatioThreshold) throws StorageException {
        this.pathSuffixSizeRatioThreshold = pathSuffixSizeRatioThreshold;
        HashMap collectorMap = new HashMap();
        pathLookupIndex.getEntries().forEach((key, value) -> {
            collectorMap.putIfAbsent(key, new ArrayList());
            ((List)collectorMap.get(key)).add(value);
        });
        for (Map.Entry entry : collectorMap.entrySet()) {
            this.pathsByNormalizedReversedPaths.put((String)entry.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
    }

    public static PreloadedMatchingPathsLookup createFrom(IPathLookupIndex pathLookupIndex, double pathSuffixSizeRatioThreshold) throws StorageException {
        return new PreloadedMatchingPathsLookup(pathLookupIndex, pathSuffixSizeRatioThreshold);
    }

    @Override
    public ImmutableList<String> lookupSuffix(String suffix) {
        if (suffix == null) {
            return ImmutableList.of();
        }
        Optional<Pair<String, ImmutableList<String>>> longestSuffixMatch = this.lookupPath(suffix, PathLookupOptions.defaults());
        if (longestSuffixMatch.isEmpty() || !((String)longestSuffixMatch.get().getFirst()).toLowerCase().endsWith(suffix.toLowerCase())) {
            return ImmutableList.of();
        }
        return (ImmutableList)longestSuffixMatch.get().getSecond();
    }

    @Override
    public Optional<Pair<String, ImmutableList<String>>> lookupPath(String path, @NonNull PathLookupOptions options) {
        if (path == null) {
            return Optional.empty();
        }
        Optional cacheLookupResult = (Optional)this.lookupResultsByNormalizedReversedPaths.get(path);
        if (cacheLookupResult != null) {
            return cacheLookupResult;
        }
        String normalizedPathReversed = PathLookupUtils.normalizeAndReversePathEnsureEnding(path);
        Optional<Pair<String, ImmutableList<String>>> result = this.lookupPath(path, normalizedPathReversed, options);
        this.lookupResultsByNormalizedReversedPaths.put(path, result);
        return result;
    }

    private Optional<Pair<String, ImmutableList<String>>> lookupPath(String path, String normalizedPathReversed, @NonNull PathLookupOptions options) {
        if (this.pathsByNormalizedReversedPaths.containsKey(normalizedPathReversed)) {
            ImmutableList<String> matchingPaths = (ImmutableList<String>)this.pathsByNormalizedReversedPaths.get(normalizedPathReversed);
            if ((matchingPaths = PathLookupUtils.applyPlausibilityCheck(path, matchingPaths, options.getPlausibilityCheck())).size() == 1) {
                String matchedPath = (String)matchingPaths.getFirst();
                return Optional.of(Pair.createPair((Object)matchedPath, (Object)ImmutableList.of((Object)matchedPath)));
            }
        }
        String reversedFileNameWithSlash = normalizedPathReversed.substring(0, normalizedPathReversed.indexOf(47) + 1);
        ConcurrentSkipListMap matchingPaths = new ConcurrentSkipListMap();
        this.pathsByNormalizedReversedPaths.streamValuesWithPrefix(reversedFileNameWithSlash).forEach(entry -> matchingPaths.put((String)entry.getKey(), (ImmutableList)entry.getValue()));
        if (matchingPaths.isEmpty() || !((String)matchingPaths.firstEntry().getKey()).startsWith(reversedFileNameWithSlash)) {
            return Optional.empty();
        }
        LongestMatchingSuffixPathsCollector longestMatchingSuffixPathsCollector = new LongestMatchingSuffixPathsCollector(normalizedPathReversed, options.shouldExcludePathsWhereOnlyFileNameMatches());
        for (Map.Entry entry2 : matchingPaths.entrySet()) {
            if (longestMatchingSuffixPathsCollector.collectPath((String)entry2.getKey(), (List)entry2.getValue())) break;
        }
        Pair lookupResult = longestMatchingSuffixPathsCollector.getLookupResult(path).orElse(null);
        if (lookupResult == null) {
            return Optional.empty();
        }
        return Optional.of(PathLookupUtils.applyPlausibilityLookupOptions(path, options, (Pair<String, ImmutableList<String>>)lookupResult));
    }

    @Override
    public Optional<String> lookupBestPath(String path, @NonNull PathLookupOptions options) {
        return this.lookupPathBestMatchCache.computeIfAbsent(path, s -> this.lookupBestPathAtomic((String)s, options));
    }

    private Optional<String> lookupBestPathAtomic(String path, @NonNull PathLookupOptions options) {
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(path, options);
        if (lookupResultOptional.isEmpty()) {
            return Optional.empty();
        }
        return PathLookupUtils.determineHighestScoringMatch(path, lookupResultOptional.get(), this.pathSuffixSizeRatioThreshold);
    }

    @Override
    public ImmutableList<String> lookupAllPaths(String path, @NonNull PathLookupOptions options) {
        return this.lookupAllPathsCache.computeIfAbsent(path, pathToLookup -> this.lookupAllPathsAtomic((String)pathToLookup, options));
    }

    private ImmutableList<String> lookupAllPathsAtomic(String path, @NonNull PathLookupOptions options) {
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(path, options);
        if (lookupResultOptional.isEmpty()) {
            return ImmutableList.of();
        }
        return (ImmutableList)lookupResultOptional.get().getSecond();
    }
}

