/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparseTrigger;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDependencyIndex;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.IncludeDirectiveMatcher;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class PreprocessorIncludeReparsingDependencyIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta basicContentIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PreprocessorIncludeReparsingDependencyIndex reparsingDependencyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PreprocessorExpansionsIndex preprocessorExpansionsIndex;
    private Pair<String, List<PreprocessorTokenReplacement>> cachedPreprocessorExpansions = null;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex tokenElementIndex;
    private Pair<String, TokenElementInfo> cachedTokenElementInfo = null;

    public void execute() throws StorageException {
        List deletedUniformPaths = this.basicContentIndexDelta.getDeletedKeysAsStrings();
        Map<String, ArrayList<String>> updatedValues = this.computeUpdatedValues(this.basicContentIndexDelta.getAddedOrChangedKeysAsStrings());
        this.reparsingDependencyIndex.putUpdatedValuesForChangedPaths(updatedValues, deletedUniformPaths);
    }

    private Map<String, ArrayList<String>> computeUpdatedValues(List<String> addedOrChangedUniformPaths) throws StorageException {
        HashMap<String, ArrayList<String>> result = HashMap.newHashMap(addedOrChangedUniformPaths.size());
        List<BasicTokenElementInfo> basicElements = this.basicTokenElementIndex.getTokenElements(addedOrChangedUniformPaths);
        for (BasicTokenElementInfo basicElement : basicElements) {
            ELanguage language = basicElement.getLanguage();
            if (!PreprocessorIncludeReparseTrigger.RELEVANT_LANGUAGES.contains(language)) continue;
            String uniformPath = basicElement.getUniformPath();
            List tokens = ScannerUtils.getTokens((String)basicElement.getText(), (ELanguage)language, (String)uniformPath);
            ArrayList<String> includedPaths = new ArrayList<String>();
            for (IToken token : tokens) {
                Optional<String> includedPath = this.determineIncludeDirectivePathIfAny(uniformPath, token);
                if (!includedPath.isPresent()) continue;
                includedPaths.add(includedPath.get());
            }
            ArrayList includeDependencyTargets = new ArrayList(CollectionUtils.map(includedPaths, PreprocessorIncludeReparsingDependencyIndex::buildDependencyTargetStorageKeyForIncludeName));
            result.put(uniformPath, includeDependencyTargets);
        }
        return result;
    }

    private Optional<String> determineIncludeDirectivePathIfAny(String uniformPath, IToken token) throws StorageException {
        Optional<String> includedPath = Optional.empty();
        IncludeDirectiveMatcher includeDirectiveMatcher = new IncludeDirectiveMatcher(token);
        if (!includeDirectiveMatcher.match()) {
            return Optional.empty();
        }
        Optional includeDirective = IncludeDirective.createIncludeDirectiveFromIncludeDirectiveMatcher((IncludeDirectiveMatcher)includeDirectiveMatcher, (IToken)token, (boolean)false);
        if (includeDirective.isPresent()) {
            includedPath = Optional.of(((IncludeDirective)includeDirective.get()).getIncludedFilePath());
        } else {
            PreprocessorIncludeTokenReplacement expansionAtToken = this.findIncludePreprocessorExpansionAtOffset(token.getOffset(), uniformPath);
            if (expansionAtToken == null) {
                return Optional.empty();
            }
            String uniformPathOfIncludedFile = expansionAtToken.uniformPathOfIncludedFile;
            if (!uniformPathOfIncludedFile.startsWith("/")) {
                includedPath = Optional.of(uniformPathOfIncludedFile);
            }
        }
        return includedPath;
    }

    private PreprocessorIncludeTokenReplacement findIncludePreprocessorExpansionAtOffset(int offset, String uniformPath) throws StorageException {
        PreprocessorIncludeTokenReplacement expansionAtToken = null;
        TokenElementInfo tokenElement = this.loadTokenElementInfo(uniformPath);
        if (tokenElement == null) {
            return null;
        }
        UnmodifiableList<IToken> filteredFileTokens = tokenElement.getTokens();
        int tokenIndex = TokenStreamUtils.indexOfByOffset(filteredFileTokens, (int)offset);
        for (PreprocessorTokenReplacement expansion : this.loadPreprocessorExpansions(uniformPath)) {
            PreprocessorIncludeTokenReplacement preprocessorIncludeTokenReplacement;
            if (!expansion.replacesOriginalTokenIndex(tokenIndex) || !(expansion instanceof PreprocessorIncludeTokenReplacement)) continue;
            expansionAtToken = preprocessorIncludeTokenReplacement = (PreprocessorIncludeTokenReplacement)expansion;
            break;
        }
        return expansionAtToken;
    }

    private List<PreprocessorTokenReplacement> loadPreprocessorExpansions(String uniformPath) throws StorageException {
        if (this.cachedPreprocessorExpansions == null || !((String)this.cachedPreprocessorExpansions.getFirst()).equals(uniformPath)) {
            this.cachedPreprocessorExpansions = Pair.createPair((Object)uniformPath, this.preprocessorExpansionsIndex.getExpansionsForUniformPath(uniformPath));
        }
        return (List)this.cachedPreprocessorExpansions.getSecond();
    }

    private @Nullable TokenElementInfo loadTokenElementInfo(String uniformPath) throws StorageException {
        if (this.cachedTokenElementInfo == null || !((String)this.cachedTokenElementInfo.getFirst()).equals(uniformPath)) {
            this.cachedTokenElementInfo = Pair.createPair((Object)uniformPath, (Object)((Object)this.tokenElementIndex.getTokenElement(uniformPath)));
        }
        return (TokenElementInfo)((Object)this.cachedTokenElementInfo.getSecond());
    }
}

