/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.google.common.collect.Sets;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexBase;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.IMetricSchemaRetriever;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricDirectoryEntryRetriever;
import com.teamscale.index.resource.retrieval_strategy.IndexMetricRetrievalStrategyBase;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyUtils;
import com.teamscale.index.testimpact.TestMetricsSynchronizer;
import com.teamscale.index.tests.TestExecutionIndexes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TestMetricRetrievalStrategy
extends IndexMetricRetrievalStrategyBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Nullable Set<String> partitions;

    public TestMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, @Nullable Set<String> partitions, IMetricSchemaRetriever schemaRetrieverFactory) {
        super(projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, false);
        this.partitions = partitions;
    }

    private static @NonNull Set<String> getPartitions(MetricDirectoryIndexBase index, @Nullable Set<String> partitions) throws StorageException {
        if (partitions == null) {
            return TestMetricRetrievalStrategy.getAllPartitions(index);
        }
        return partitions;
    }

    private static Set<String> getAllPartitions(MetricDirectoryIndexBase index) throws StorageException {
        MetricDirectoryEntry container = index.getMetricDirectoryEntry(UniformPath.EType.TEST_EXECUTION.getPrefix());
        if (container == null) {
            return Set.of();
        }
        return CollectionUtils.mapToSet((Collection)container.getChildMetricsMap().keySet(), path -> UniformPath.unescapeSegment((String)StringUtils.stripPrefix((String)path, (String)(UniformPath.EType.TEST_EXECUTION.getPrefix() + UniformPathUtils.SEPARATOR))));
    }

    @Override
    protected MetricDirectoryIndexBase openMetricDirectoryIndex(HistoryAccessOption historyAccessOption) throws StorageException {
        return (MetricDirectoryIndexBase)this.projectStorageSystem.openProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRICS_DIRECTORY_INDEX_TYPE, "test-execution-metric-directory", historyAccessOption);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryIndexBase index = this.openMetricDirectoryIndex(historyAccessOption);
        MetricDirectorySchema metricDirectorySchema = this.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption());
        return TestMetricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, index, metricDirectorySchema, this.partitions);
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        TestMetricRetrievalStrategy.ensureNotNullOrEmpty(uniformPathPrefixes);
        MetricDirectoryIndexBase metricDirectoryIndex = this.openMetricDirectoryIndex(historyAccessOption);
        Set<String> partitions = TestMetricRetrievalStrategy.getPartitions(metricDirectoryIndex, this.partitions);
        List<String> containerPrefixes = UniformPathCompatibilityUtil.convertCollection(uniformPathPrefixes).stream().flatMap(path -> TestMetricRetrievalStrategy.getContainerPaths(path, partitions).stream()).collect(Collectors.toList());
        List<MetricDirectoryEntry> metricDirectoryEntries = super.getMetricDirectoryEntries(containerPrefixes, historyAccessOption);
        Map<UniformPath, List<MetricDirectoryEntry>> metricEntriesByPath = metricDirectoryEntries.stream().filter(e -> !TestMetricRetrievalStrategy.isNestedTestExecution(e.getUniformPath())).collect(Collectors.groupingBy(t -> TestMetricRetrievalStrategy.getUnpartitionedPath(t.getUniformPath())));
        ArrayList<MetricDirectoryEntry> aggregatedMetrics = new ArrayList<MetricDirectoryEntry>();
        MetricDirectorySchema metricDirectorySchema = this.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption());
        metricEntriesByPath.forEach((path, entries) -> aggregatedMetrics.add(TestMetricRetrievalStrategy.mergeEntries(path, entries, metricDirectorySchema)));
        return aggregatedMetrics;
    }

    @Override
    public boolean hasMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        if (historyAccessOption == null) {
            return false;
        }
        return this.getMetricDirectoryEntry(uniformPath, historyAccessOption) != null;
    }

    private static boolean isNestedTestExecution(String uniformPath) {
        return uniformPath.startsWith(UniformPath.EType.TEST_IMPLEMENTATION.getPrefix()) && uniformPath.contains(UniformPath.EType.TEST_EXECUTION.getPrefix());
    }

    @VisibleForTesting
    static UniformPath getUnpartitionedPath(String path) {
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)path);
        return UniformPath.ofSegments((UniformPath.EType)uniformPath.getType(), (String[])new String[0]).resolve(uniformPath.getSubPath(1));
    }

    @Override
    protected List<TrendIndexBase.TrendEntry<Object[]>> extractTrend(MetricTrendIndex trendIndex, UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)end);
        List<List<TrendIndexBase.TrendEntry<Object[]>>> trendEntries = this.getTrendsPerPartition(trendIndex, uniformPath, start, end, historyAccessOption);
        return TestMetricRetrievalStrategy.computeAggregatedTrendEntries(trendEntries, this.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption()), MetricRetrievalStrategyUtils.getMetricSources(this.getMetricDirectorySchema(historyAccessOption.cloneToUnbranchedAccessOption())));
    }

    private static List<TrendIndexBase.TrendEntry<Object[]>> computeAggregatedTrendEntries(List<List<TrendIndexBase.TrendEntry<Object[]>>> trendEntries, MetricDirectorySchema metricDirectorySchema, List<IMetricSource> metricSources) {
        ArrayList<Integer> indices = new ArrayList<Integer>(Collections.nCopies(trendEntries.size(), 0));
        List<Long> timestamps = trendEntries.stream().flatMap(Collection::stream).map(TrendIndexBase.TrendEntry::timestamp).distinct().sorted().toList();
        ArrayList<TrendIndexBase.TrendEntry<Object[]>> aggregatedTrend = new ArrayList<TrendIndexBase.TrendEntry<Object[]>>();
        for (Long timestamp : timestamps) {
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            for (int i = 0; i < trendEntries.size(); ++i) {
                Integer j = (Integer)indices.get(i);
                List<TrendIndexBase.TrendEntry<Object[]>> entries = trendEntries.get(i);
                if (entries.get(j).timestamp() > timestamp) continue;
                while (j < entries.size() - 1 && entries.get(j + 1).timestamp() <= timestamp) {
                    Integer n = j;
                    j = j + 1;
                }
                indices.set(i, j);
                values.add((Object[])entries.get(j).value());
            }
            aggregatedTrend.add((TrendIndexBase.TrendEntry<Object[]>)new TrendIndexBase.TrendEntry(timestamp.longValue(), (Object)TestMetricRetrievalStrategy.getAggregatedValues(values, metricDirectorySchema, metricSources)));
        }
        return aggregatedTrend;
    }

    private @NonNull List<List<// Could not load outer class - annotation placement on inner may be incorrect
    TrendIndexBase.TrendEntry<Object[]>>> getTrendsPerPartition(MetricTrendIndex trendIndex, UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryIndexBase metricDirectoryIndex = this.openMetricDirectoryIndex(historyAccessOption);
        Set<String> partitions = TestMetricRetrievalStrategy.getPartitions(metricDirectoryIndex, this.partitions);
        ArrayList<List<TrendIndexBase.TrendEntry<Object[]>>> trendEntries = new ArrayList<List<TrendIndexBase.TrendEntry<Object[]>>>();
        for (String containerPath : TestMetricRetrievalStrategy.getContainerPaths(uniformPath, partitions)) {
            List<TrendIndexBase.TrendEntry<Object[]>> trend = super.extractTrend(trendIndex, UniformPathCompatibilityUtil.convert((String)containerPath), start, end);
            if (trend.isEmpty()) continue;
            trendEntries.add(CollectionUtils.reverse(trend));
        }
        return trendEntries;
    }

    @Override
    public IMetricDirectoryEntryRetriever getMetricDirectoryEntryRetriever(HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryIndexBase metricDirectoryIndex = this.openMetricDirectoryIndex(historyAccessOption);
        MetricDirectorySchema schema = this.getMetricDirectorySchema();
        return uniformPath -> TestMetricRetrievalStrategy.getMetricDirectoryEntry(UniformPathCompatibilityUtil.convert((String)uniformPath), metricDirectoryIndex, schema, this.partitions);
    }

    private static @Nullable MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, MetricDirectoryIndexBase index, MetricDirectorySchema metricDirectorySchema, @Nullable Set<String> partitions) throws StorageException {
        List<MetricDirectoryEntry> entries = index.getMetricDirectoryEntries(TestMetricRetrievalStrategy.getContainerPaths(uniformPath, TestMetricRetrievalStrategy.getPartitions(index, partitions))).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (entries.isEmpty()) {
            LOGGER.info("No entry metric directory entry found for: " + String.valueOf(uniformPath));
            return null;
        }
        for (MetricDirectoryEntry entry : entries) {
            ResourceServiceUtils.adjustSchemaEntries(metricDirectorySchema, entry);
        }
        return TestMetricRetrievalStrategy.mergeEntries(uniformPath, entries, metricDirectorySchema);
    }

    private static MetricDirectoryEntry mergeEntries(UniformPath uniformPath, List<MetricDirectoryEntry> entries, MetricDirectorySchema metricDirectorySchema) {
        List<IMetricSource> metricSources = MetricRetrievalStrategyUtils.getMetricSources(metricDirectorySchema);
        MetricDirectoryEntry metricDirectoryEntry = TestMetricRetrievalStrategy.appendChildMetricDirectoryEntry(uniformPath, entries, metricDirectorySchema, metricSources);
        Object[] aggregated = TestMetricRetrievalStrategy.getAggregatedValues(CollectionUtils.map(entries, MetricDirectoryEntry::getValues), metricDirectorySchema, metricSources);
        metricDirectoryEntry.setValues(aggregated);
        return metricDirectoryEntry;
    }

    private static @NonNull MetricDirectoryEntry appendChildMetricDirectoryEntry(UniformPath uniformPath, List<MetricDirectoryEntry> entries, MetricDirectorySchema metricDirectorySchema, List<IMetricSource> metricSources) {
        ListMap childMetricLists = new ListMap();
        for (MetricDirectoryEntry entry : entries) {
            for (Map.Entry stringEntry : entry.getChildMetricsMap().entrySet()) {
                if (TestMetricRetrievalStrategy.isNestedTestExecution((String)stringEntry.getKey())) continue;
                childMetricLists.add((Object)StringUtils.stripPrefix((String)((String)stringEntry.getKey()), (String)(entry.getUniformPath() + UniformPathUtils.SEPARATOR)), (Object)((Object[])stringEntry.getValue()));
            }
        }
        MetricDirectoryEntry metricDirectoryEntry = new MetricDirectoryEntry(uniformPath.toString(), metricDirectorySchema);
        for (String childKey : childMetricLists.getKeys()) {
            List metricsToMerge = (List)childMetricLists.getCollection((Object)childKey);
            Object[] aggregated = new Object[metricSources.size()];
            for (int i = 0; i < metricSources.size(); ++i) {
                int finalI = i;
                List values = metricsToMerge.stream().map(metrics -> metrics[finalI]).filter(Objects::nonNull).collect(Collectors.toList());
                aggregated[i] = metricSources.get(i).aggregate(values, metricDirectorySchema.getEntry(i));
            }
            metricDirectoryEntry.setChildMetrics(String.valueOf(uniformPath) + UniformPathUtils.SEPARATOR + childKey, aggregated);
        }
        return metricDirectoryEntry;
    }

    private static Object[] getAggregatedValues(List<Object[]> entries, MetricDirectorySchema metricDirectorySchema, List<IMetricSource> metricSources) {
        Object[] aggregated = new Object[metricSources.size()];
        for (int i = 0; i < metricSources.size(); ++i) {
            int finalI = i;
            List values = CollectionUtils.map(entries, entry -> entry[finalI]);
            values.removeIf(Objects::isNull);
            aggregated[i] = metricSources.get(i).aggregate(values, metricDirectorySchema.getEntry(i));
        }
        return aggregated;
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        MetricTrendIndex trendIndex = (MetricTrendIndex)this.projectStorageSystem.openProjectIndex(TestExecutionIndexes.TEST_EXECUTION_METRICS_TREND_INDEX_TYPE, "test-execution-metric-trend", null);
        return this.extractTrend(trendIndex, uniformPath, start, end);
    }

    private static @NonNull List<String> getContainerPaths(UniformPath uniformPath, Set<String> partitions) {
        return CollectionUtils.map((Collection)Sets.union(partitions, Set.of("-implementation-")), partition -> TestMetricsSynchronizer.getPartitionedPath(partition, uniformPath.toString()));
    }
}

