/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.simulink.clones.InvertedSimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneChangeIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SimulinkCloneChangeIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkCloneChangeIndex changeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private InvertedSimulinkCloneFragmentIndex invertedFragmentIndex;
    @DeltaSource(value=InvertedSimulinkCloneFragmentIndex.class)
    private KeyDelta invertedFragmentDelta;

    public void execute() throws StorageException {
        List<List<SimulinkCloneFragment>> fragmentLists;
        List<String> uniformPathsToUpdate;
        if (!this.contentDelta.getDeletedKeys().isEmpty()) {
            this.changeIndex.removeUniformPaths(this.contentDelta.getDeletedKeysAsStrings());
        }
        if (!(uniformPathsToUpdate = (fragmentLists = this.invertedFragmentIndex.getFragmentLists(CollectionUtils.map((Collection)this.invertedFragmentDelta.getAddedOrChangedKeys(), key -> ByteArrayUtils.byteArrayToLong((byte[])key.getBytes())))).stream().flatMap(Collection::stream).map(SimulinkCloneFragment::getUniformPath).distinct().collect(Collectors.toList())).isEmpty()) {
            this.changeIndex.updateTimestamps(uniformPathsToUpdate, this.getSchedulingCommit().getTimestamp());
        }
    }
}

