/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.simulink.clones.InvertedSimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneChangeIndex;
import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCoverableBlockCountIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.simulink.util.SimulinkUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SimulinkCloneDetector
extends ChangeProcessorAnalysisStep {
    public static final String FINDINGS_PARTITION = "simulink-clones";
    public static final String SIZE_PROPERTY = "Size";
    public static final String MIN_CLONE_SIZE_PARAMETER = "min-clone-size";
    @DeltaSource(value=SimulinkCloneChangeIndex.class)
    private KeyDelta cloneChangeDelta;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkCloneFragmentIndex fragmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkCoverableBlockCountIndex blockCountIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private InvertedSimulinkCloneFragmentIndex invertedFragmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex findingsSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    @StepParameter(value="min-clone-size")
    private int minCloneSize;

    public void execute() throws StorageException {
        this.metricsIndex.removeEntries((Collection)CollectionUtils.filter((Collection)this.contentDelta.getDeletedKeysAsStrings(), path -> !SimulinkUtils.isSimulinkModelPath((String)path)), new String[]{"cloned-blocks", "non-trivial-blocks"});
        if (!this.cloneChangeDelta.getDeletedKeys().isEmpty()) {
            this.findingsIndex.removeFindingsForPartitionsAndPaths(FINDINGS_PARTITION, this.cloneChangeDelta.getDeletedKeysAsStrings());
            this.metricsIndex.removeEntries((Collection)this.cloneChangeDelta.getDeletedKeysAsStrings(), new String[]{"cloned-blocks", "non-trivial-blocks"});
        }
        ArrayList<IndexFinding> cloneFindings = new ArrayList<IndexFinding>();
        for (String uniformPath : this.cloneChangeDelta.getAddedOrChangedKeysAsStrings()) {
            this.detectClones(uniformPath, cloneFindings);
        }
        this.calculateAndStoreMetricsAndFindings(SimulinkCloneDetector.filterFinding(cloneFindings));
        PairList zeroValues = new PairList();
        for (String uniformPath : CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), path -> !SimulinkUtils.isSimulinkModelPath((String)path))) {
            zeroValues.add((Object)uniformPath, (Object)0.0);
        }
        this.metricsIndex.setMetricValues(zeroValues, "non-trivial-blocks");
        this.metricsIndex.setMetricValues(zeroValues, "cloned-blocks");
    }

    private void detectClones(String uniformPath, List<IndexFinding> cloneFindings) throws StorageException {
        PairList<String, List<SimulinkCloneFragment>> parentIdsAndFragments = this.fragmentIndex.getFragmentsForUniformPath(uniformPath);
        CollectionUtils.sortByFirst(parentIdsAndFragments);
        String ignoredPrefix = null;
        for (int i = 0; i < parentIdsAndFragments.size(); ++i) {
            String parentId = (String)parentIdsAndFragments.getFirst(i);
            if (ignoredPrefix != null && parentId.startsWith(ignoredPrefix)) continue;
            SetMap<String, String> elementsByOriginKey = this.determineClonedElementsByOriginKey((List)parentIdsAndFragments.getSecond(i));
            ArrayList<QualifiedNameLocation> siblingLocations = new ArrayList<QualifiedNameLocation>();
            int size = this.calculateSizeAndSiblings(elementsByOriginKey, SimulinkCloneFragment.buildRawKey(uniformPath, parentId), siblingLocations);
            if (size < this.minCloneSize || siblingLocations.isEmpty()) continue;
            cloneFindings.add(SimulinkCloneDetector.createCloneFinding(uniformPath, parentId, size, siblingLocations));
            ignoredPrefix = parentId;
        }
    }

    private SetMap<String, String> determineClonedElementsByOriginKey(List<SimulinkCloneFragment> originFragments) throws StorageException {
        List<Long> hashes = originFragments.stream().map(SimulinkCloneFragment::getHash).distinct().collect(Collectors.toList());
        List<List<SimulinkCloneFragment>> otherFragments = this.invertedFragmentIndex.getFragmentLists(hashes);
        SetMap elementsByOriginKey = new SetMap();
        for (List<SimulinkCloneFragment> fragments : otherFragments) {
            for (SimulinkCloneFragment fragment : fragments) {
                elementsByOriginKey.addAll((Object)fragment.getRawKey(), fragment.getBlockNames());
            }
        }
        return elementsByOriginKey;
    }

    private int calculateSizeAndSiblings(SetMap<String, String> elementsByOriginKey, String referenceRawKey, List<QualifiedNameLocation> siblingLocations) throws StorageException {
        int size = 0;
        for (String rawKey : elementsByOriginKey.getKeys()) {
            List rawQueryKeys;
            int weight;
            Set names = (Set)elementsByOriginKey.getCollection((Object)rawKey);
            if (names.size() < 2 || (weight = this.blockCountIndex.getCountSumForRawKeys(rawQueryKeys = CollectionUtils.map((Collection)names, name -> rawKey + "/" + name))) < this.minCloneSize) continue;
            if (rawKey.equals(referenceRawKey)) {
                size = weight;
                continue;
            }
            if (rawKey.startsWith(referenceRawKey) || referenceRawKey.startsWith(rawKey)) continue;
            Pair<String, String> uniformPathAndParentId = SimulinkCloneFragment.splitRawKey(rawKey);
            siblingLocations.add(new QualifiedNameLocation((String)uniformPathAndParentId.getSecond(), (String)uniformPathAndParentId.getFirst()));
        }
        return size;
    }

    private static List<IndexFinding> filterFinding(List<IndexFinding> findings) {
        int oldSize = findings.size() + 1;
        while (oldSize != findings.size()) {
            HashSet allCloneLocations = new HashSet(CollectionUtils.map(findings, DetachedFinding::getLocationString));
            for (IndexFinding finding2 : findings) {
                finding2.removeMatchingSiblingLocations(siblingLocation -> !allCloneLocations.contains(siblingLocation.toLocationString()));
            }
            oldSize = findings.size();
            findings.removeIf(finding -> finding.getSiblingLocations().isEmpty());
        }
        return findings;
    }

    private void calculateAndStoreMetricsAndFindings(List<IndexFinding> cloneFindings) throws StorageException {
        Map<String, List<IndexFinding>> findingsByUniformPath = cloneFindings.stream().collect(Collectors.groupingBy(finding -> finding.getLocation().getUniformPath()));
        PairList groupedFindings = new PairList();
        PairList coverableMetricValue = new PairList();
        PairList coveredMetricValue = new PairList();
        for (String uniformPath : this.cloneChangeDelta.getAddedOrChangedKeysAsStrings()) {
            coverableMetricValue.add((Object)uniformPath, (Object)this.blockCountIndex.getRootCount(uniformPath));
            ArrayList findings = new ArrayList(findingsByUniformPath.getOrDefault(uniformPath, Collections.emptyList()));
            groupedFindings.add((Object)uniformPath, findings);
            int coveredBlocks = 0;
            for (IndexFinding finding2 : findings) {
                coveredBlocks += ((Integer)finding2.getProperties().get(SIZE_PROPERTY)).intValue();
            }
            coveredMetricValue.add((Object)uniformPath, (Object)coveredBlocks);
        }
        this.findingsIndex.setFindings(FINDINGS_PARTITION, groupedFindings, this.findingsSchemaIndex.getFindingsSchema());
        this.metricsIndex.setMetricValues(coverableMetricValue, "non-trivial-blocks");
        this.metricsIndex.setMetricValues(coveredMetricValue, "cloned-blocks");
    }

    private static IndexFinding createCloneFinding(String uniformPath, String parentId, int size, List<QualifiedNameLocation> siblingLocations) {
        IndexFinding finding = new IndexFinding("Model Clones", "Redundancy", "Clone with " + size + " blocks", (ElementLocation)new QualifiedNameLocation(parentId, uniformPath));
        siblingLocations.forEach(arg_0 -> ((IndexFinding)finding).addSiblingLocation(arg_0));
        finding.setProperty(SIZE_PROPERTY, (Object)size);
        finding.setProperty("Instances", (Object)(siblingLocations.size() + 1));
        return finding;
    }
}

