/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.simulink.clones.BlockNormalizer;
import com.teamscale.index.simulink.clones.BlockTripleGenerator;
import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentIndex;
import com.teamscale.index.simulink.clones.SimulinkCoverableBlockCountIndex;
import com.teamscale.index.simulink.content.SimulinkFileSynchronizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.jpountz.xxhash.StreamingXXHash64;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;

public class SimulinkCloneFragmentSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkCloneFragmentIndex fragmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkCoverableBlockCountIndex blockCountIndex;

    public void execute() throws StorageException {
        List<String> deletedKeys = SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getDeletedKeysAsStrings());
        if (!deletedKeys.isEmpty()) {
            this.fragmentIndex.deleteFragmentsForModels(deletedKeys);
            this.blockCountIndex.deleteValuesForModels(deletedKeys);
        }
        List<String> uniformPaths = SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getAddedOrChangedKeysAsStrings());
        LazyModelLoader modelLoader = new LazyModelLoader(this.binaryContentIndex);
        modelLoader.preloadModels(uniformPaths);
        for (String uniformPath : uniformPaths) {
            Optional<SimulinkModel> model = modelLoader.getModelByUniformPath(uniformPath);
            if (!model.isPresent()) continue;
            this.updateFragments(uniformPath, model.get());
            this.updateCoverableBlockCounts(uniformPath, model.get());
        }
    }

    private void updateFragments(String uniformPath, SimulinkModel model) throws StorageException {
        ArrayList<SimulinkCloneFragment> fragments = new ArrayList<SimulinkCloneFragment>();
        SimulinkCloneFragmentSynchronizer.calculateHashAndFragments(uniformPath, (SimulinkBlock)model, fragments);
        this.fragmentIndex.deleteFragmentsForModels(Collections.singletonList(uniformPath));
        this.fragmentIndex.insertFragments(fragments);
    }

    private void updateCoverableBlockCounts(String uniformPath, SimulinkModel model) throws StorageException {
        PairList blockCountValues = new PairList();
        int sum = SimulinkCloneFragmentSynchronizer.calculateCoverableBlockCounts(uniformPath, (SimulinkBlock)model, (PairList<String, Integer>)blockCountValues);
        blockCountValues.add((Object)SimulinkCoverableBlockCountIndex.makeRootKey(uniformPath), (Object)sum);
        this.blockCountIndex.deleteValuesForModels(Collections.singletonList(uniformPath));
        this.blockCountIndex.updateVaues((PairList<String, Integer>)blockCountValues);
    }

    private static int calculateCoverableBlockCounts(String uniformPath, SimulinkBlock block, PairList<String, Integer> blockCountValues) {
        int sum = 0;
        if (block.hasSubBlocks()) {
            for (SimulinkBlock child : block.getSubBlocks()) {
                sum += SimulinkCloneFragmentSynchronizer.calculateCoverableBlockCounts(uniformPath, child, blockCountValues);
            }
        }
        blockCountValues.add((Object)SimulinkCoverableBlockCountIndex.makeRawKey(uniformPath, block.getId()), (Object)(sum += SimulinkCloneFragmentSynchronizer.determineCoverableWeight(block)));
        return sum;
    }

    private static int determineCoverableWeight(SimulinkBlock block) {
        switch (block.getResolvedType()) {
            case "SubSystem": 
            case "Model": 
            case "Inport": 
            case "InportShadow": 
            case "Outport": 
            case "Terminator": 
            case "Ground": 
            case "BusCreator": 
            case "BusSelector": {
                return 0;
            }
        }
        return 1;
    }

    private static String calculateHashAndFragments(String uniformPath, SimulinkBlock block, List<SimulinkCloneFragment> fragments) {
        HashMap<String, String> idToHash = new HashMap<String, String>();
        for (SimulinkBlock child : block.getSubBlocks()) {
            if (!child.hasSubBlocks()) continue;
            idToHash.put(child.getId(), SimulinkCloneFragmentSynchronizer.calculateHashAndFragments(uniformPath, child, fragments));
        }
        BlockNormalizer normalizer = new BlockNormalizer(idToHash);
        ArrayList<SimulinkCloneFragment> localFragments = new ArrayList<SimulinkCloneFragment>();
        BlockTripleGenerator.TripleGenerationResult triples = BlockTripleGenerator.generateTriples((Collection<SimulinkBlock>)block.getSubBlocks());
        for (SimulinkBlock simulinkBlock : triples.getSingletonBlocks()) {
            long hash = XXHashUtils.xxhash64((String)normalizer.getNormalizationLabel(simulinkBlock));
            localFragments.add(new SimulinkCloneFragment(uniformPath, block.getId(), Collections.singletonList(simulinkBlock.getName()), hash));
        }
        for (Pair pair : triples.getPairs()) {
            localFragments.add(SimulinkCloneFragmentSynchronizer.buildFragment(uniformPath, block.getId(), Arrays.asList((SimulinkBlock)pair.getFirst(), (SimulinkBlock)pair.getSecond()), normalizer));
        }
        for (List list : triples.getTriples()) {
            localFragments.add(SimulinkCloneFragmentSynchronizer.buildFragment(uniformPath, block.getId(), list, normalizer));
        }
        fragments.addAll(localFragments);
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        localFragments.forEach(fragment -> XXHashUtils.updateHash((StreamingXXHash64)hash, (byte[])ByteArrayUtils.longToByteArray((long)fragment.getHash())));
        return Long.toHexString(hash.getValue());
    }

    private static SimulinkCloneFragment buildFragment(String uniformPath, String parentId, List<SimulinkBlock> blocks, BlockNormalizer normalizer) {
        IdentityHashSet inLines = new IdentityHashSet();
        IdentityHashSet outLines = new IdentityHashSet();
        for (SimulinkBlock simulinkBlock : blocks) {
            inLines.addAll(simulinkBlock.getInLines());
            outLines.addAll(simulinkBlock.getOutLines());
        }
        ArrayList<String> lineLabels = new ArrayList<String>();
        for (SimulinkLine line : inLines) {
            if (!outLines.contains(line)) continue;
            lineLabels.add(normalizer.getNormalizationLabel(line));
        }
        long l = XXHashUtils.xxhash64((String)StringUtils.concat((Iterable)CollectionUtils.sort(lineLabels), (String)","));
        return new SimulinkCloneFragment(uniformPath, parentId, CollectionUtils.map(blocks, SimulinkElementBase::getName), l);
    }
}

