/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.comment_analysis.utils.CommentUtils;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.simulink.tracing.SimulinkCoderGeneratorTracingUtils;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TracelinkAbbreviationIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern ABBREVIATION_PATTERN = Pattern.compile("'<([A-Za-z0-9]+)>'\\s*:\\s*'?([^']+)'?");
    @VisibleForTesting
    public static final String BACE_TOOLCHAIN_HINT = "Generated by MBSE BACE Toolchain";
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TracelinkAbbreviationIndex abbreviationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex modelInfoIndex;

    public void execute() throws StorageException {
        PairList abbreviationValues = new PairList();
        List<TokenElementInfo> elements = this.contentIndex.getTokenElements(this.contentDelta.getAddedOrChangedKeysAsStrings(), true);
        for (TokenElementInfo element : elements) {
            if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(element.getLanguage()) || !element.getText().contains(BACE_TOOLCHAIN_HINT)) continue;
            TracelinkAbbreviationIndexSynchronizer.processAbbreviations(element.getUniformPath(), CommentUtils.getCommentTokens(element.getTokens()), (PairList<String, String>)abbreviationValues);
        }
        if (!abbreviationValues.isEmpty()) {
            this.abbreviationIndex.setAbbreviations((PairList<String, String>)abbreviationValues);
        }
    }

    @VisibleForTesting
    public static void processAbbreviations(String uniformPath, List<IToken> commentTokens, PairList<String, String> abbreviationValues) {
        PairList abbreviations = new PairList();
        for (IToken commentToken : commentTokens) {
            TracelinkAbbreviationIndexSynchronizer.extractAbbreviations(commentToken, (PairList<String, String>)abbreviations);
        }
        if (abbreviations.isEmpty()) {
            return;
        }
        Optional<String> modelName = SimulinkCoderGeneratorTracingUtils.getModelNameFromComments(commentTokens);
        if (!modelName.isPresent()) {
            LOGGER.error("Could not extract model name for file containing abbreviations: " + uniformPath);
            return;
        }
        for (int i = 0; i < abbreviations.size(); ++i) {
            String modelAndAbbreviation = UniformPathUtils.concatenate((String[])new String[]{modelName.get(), (String)abbreviations.getFirst(i)});
            String modelAndDestination = UniformPathUtils.concatenate((String[])new String[]{modelName.get(), (String)abbreviations.getSecond(i)});
            abbreviationValues.add((Object)modelAndAbbreviation, (Object)modelAndDestination);
        }
    }

    private static void extractAbbreviations(IToken commentToken, PairList<String, String> abbreviations) {
        for (String commentTextLine : CommentUtils.getCommentTextLines(commentToken)) {
            Matcher matcher = ABBREVIATION_PATTERN.matcher(commentTextLine);
            if (!matcher.find()) continue;
            String abbreviation = matcher.group(1);
            String full = UniformPathUtils.stripProject((String)(matcher.group(2) + UniformPathUtils.SEPARATOR));
            full = StringUtils.stripSuffix((String)full, (String)UniformPathUtils.SEPARATOR);
            abbreviations.add((Object)abbreviation, (Object)full);
        }
    }
}

