/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.index.testgap.abap.AbapIncludeIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class AbapIncludeSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final int BATCH_SIZE = 500;
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="content")
    private TokenElementIndex oldContentIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AbapIncludeIndex includeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathLookupIndex lookupIndex;

    public void execute() throws StorageException {
        for (List deletedPathsInBatch : Lists.partition((List)this.contentDelta.getDeletedKeysAsStrings(), (int)500)) {
            List<TokenElementInfo> deletedFiles = this.oldContentIndex.getTokenElements(deletedPathsInBatch);
            ArrayList<String> pathsToRemoveIncludesFor = new ArrayList<String>();
            for (int i = 0; i < deletedPathsInBatch.size(); ++i) {
                if (deletedFiles.get(i).getLanguage() != ELanguage.ABAP) continue;
                pathsToRemoveIncludesFor.add(deletedFiles.get(i).getUniformPath());
            }
            this.includeIndex.removeIncludes(pathsToRemoveIncludesFor);
        }
        for (List addedOrChangedPathsInBatch : Lists.partition((List)this.contentDelta.getAddedOrChangedKeysAsStrings(), (int)500)) {
            List<TokenElementInfo> addedOrChangedFiles = this.contentIndex.getTokenElements(addedOrChangedPathsInBatch);
            for (TokenElementInfo element : addedOrChangedFiles) {
                if (element == null || element.getLanguage() != ELanguage.ABAP) continue;
                this.includeIndex.storeIncludes(element.getUniformPath(), this.getIncludesOf(element));
            }
        }
    }

    private Set<String> getIncludesOf(TokenElementInfo element) {
        ArrayList includes = new ArrayList();
        ShallowEntity.traverse(element.getShallowEntitiesWithoutPreprocessorTokens(), e -> AbapIncludeSynchronizer.addInclude(e, includes));
        List includeNames = CollectionUtils.map(includes, AbapUtils::formatAbapIdentifier);
        HashSet<String> targets = new HashSet<String>();
        for (String name : includeNames) {
            this.lookupObject(name).ifPresent(targets::add);
        }
        return targets;
    }

    private static boolean addInclude(ShallowEntity entity, List<String> includes) {
        if (!LanguageFeatureParser.ABAP.isProgramInclude(entity)) {
            return true;
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        includes.add(((IToken)tokens.get(1)).getText().toUpperCase());
        return false;
    }

    private Optional<String> lookupObject(String name) {
        Optional<Pair<String, ImmutableList<String>>> lookupResult = this.lookupIndex.lookupPath(name + ".abap", PathLookupOptions.defaults());
        if (lookupResult.isEmpty()) {
            lookupResult = this.lookupIndex.lookupPath(name.replace("_", "-") + ".abap", PathLookupOptions.defaults());
        }
        List paths = new ArrayList();
        if (lookupResult.isPresent()) {
            paths = (List)lookupResult.get().getSecond();
        } else if (AbapUtils.GENERATED_BW_PROGRAM_NAME.matcher(name).matches()) {
            paths = this.lookupIndex.lookupSuffix(name + ").abap");
        }
        paths = CollectionUtils.filter(paths, path -> AbapIncludeSynchronizer.isPossibleIncludeTarget(path));
        if (paths.isEmpty()) {
            return Optional.empty();
        }
        if (paths.size() > 1) {
            LOGGER.error("Found multiple paths for object '" + name + "', although ABAP object names should be unique: " + String.valueOf(paths) + ". File layout seems corrupted. Please issue a support request.");
        }
        return Optional.of((String)CollectionUtils.getAny(paths));
    }

    private static boolean isPossibleIncludeTarget(String path) {
        try {
            ParsedAbapElementPath parsedPath = new ParsedAbapElementPath(path);
            return parsedPath.isPossibleIncludeTarget();
        }
        catch (ConQATException e) {
            LOGGER.error("Path " + path + " does not refer to a valid ABAP file path.", (Throwable)e);
            return false;
        }
    }
}

