/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.assessment;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.ETgaAssessment;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class AssessedTgaData {
    private static final Set<ETestGapState> ADDITION_OR_CHANGE = EnumSet.of(ETestGapState.UNTESTED_ADDITION, ETestGapState.UNTESTED_CHANGE);
    private static final Set<ETestGapState> GRAY_STATES = EnumSet.of(ETestGapState.NOT_EXECUTED, ETestGapState.UNCHANGED);
    private final List<AssessedMethodData> methods;

    public AssessedTgaData(List<AssessedMethodData> methods) {
        this.methods = methods;
    }

    public List<AssessedMethodData> getMethods() {
        return this.methods;
    }

    public List<AssessedMethodData> filterByGrayState(boolean excludeGrayMethods) {
        if (!excludeGrayMethods) {
            return this.methods;
        }
        return CollectionUtils.filter(this.methods, method -> !GRAY_STATES.contains((Object)method.getTestGapState()));
    }

    public List<AssessedMethodData> getFilteredUnchangedMethods(boolean excludeUnchangedMethods, boolean isTestGapsOnly) {
        if (!excludeUnchangedMethods) {
            return this.methods;
        }
        ETgaAssessmentType assessmentType = isTestGapsOnly ? ETgaAssessmentType.TEST_GAP : ETgaAssessmentType.CHURN;
        return CollectionUtils.filter(this.methods, method -> ADDITION_OR_CHANGE.contains((Object)method.getAssessment().getStateForAssessmentType(assessmentType)));
    }

    public List<AssessedMethodData> getChangedMethods(boolean isTestGapsOnly) {
        return this.getFilteredUnchangedMethods(true, isTestGapsOnly);
    }

    public String toString() {
        return "AssessedTestGapData [" + String.valueOf(this.methods) + "]";
    }

    public static class AssessedMethodData {
        public static final Comparator<AssessedMethodData> UNIFORM_PATH_COMPARATOR = Comparator.comparing(method -> method.getLocation().getUniformPath());
        public static final Comparator<AssessedMethodData> METHOD_NAME_COMPARATOR = Comparator.comparing(AssessedMethodData::getMethodName);
        private final MethodLocation location;
        private final ETgaAssessment assessment;
        private final String methodName;
        private final long lastChangeTimestamp;
        private final long lastTestTimestamp;
        private final ETestGapState state;
        private final TeamscaleIssueId lastChangedInIssueId;

        @VisibleForTesting
        public AssessedMethodData(ETgaAssessment assessment) {
            this(null, assessment, assessment.getStateForAssessmentType(ETgaAssessmentType.TEST_GAP), null, 0L, null, -1L);
        }

        public AssessedMethodData(MethodLocation location, ETgaAssessment assessment, ETestGapState state, String methodName, long lastChangeTimestamp, TeamscaleIssueId lastChangedInIssueId, long lastTestTimestamp) {
            this.location = location;
            this.assessment = assessment;
            this.state = state;
            this.methodName = methodName;
            this.lastChangeTimestamp = lastChangeTimestamp;
            this.lastChangedInIssueId = lastChangedInIssueId;
            this.lastTestTimestamp = lastTestTimestamp;
        }

        public long getLastChangeTimestamp() {
            return this.lastChangeTimestamp;
        }

        public long getLastTestTimestamp() {
            return this.lastTestTimestamp;
        }

        public MethodLocation getLocation() {
            return this.location;
        }

        public ETgaAssessment getAssessment() {
            return this.assessment;
        }

        public ETestGapState getTestGapState() {
            return this.state;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public TeamscaleIssueId getLastChangedInIssueId() {
            return this.lastChangedInIssueId;
        }

        public String toString() {
            return "AssessedMethodData [location=" + String.valueOf(this.location) + ", state=" + String.valueOf((Object)this.assessment) + ", methodName=" + this.methodName + ", lastChangeTimestamp=" + this.lastChangeTimestamp + ", lastChangedInIssueId=" + String.valueOf(this.lastChangedInIssueId) + "]";
        }
    }
}

