/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class TestQueryDataRetriever
implements ITgaDataRetriever {
    private final MethodInfoIndex methodInfoIndex;
    private final CrossAnnotator crossAnnotator;
    private final List<String> partitions;
    private final MethodIdIndex methodIdIndex;
    private final CoverageUnitToMethodsMapIndex testsToMethodsMapIndex;
    private final ExtendedResourceTypeIndex extendedResourceTypeIndex;
    private final boolean showOnlyExecutedMethods;
    private final Set<UniformPath> testUniformPaths;
    private final CodeScopesMappingIndex codeScopesMappingIndex;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public TestQueryDataRetriever(MethodInfoIndex methodInfoIndex, CrossAnnotator crossAnnotator, List<String> partitions, MethodIdIndex methodIdIndex, CoverageUnitToMethodsMapIndex testsToMethodsMapIndex, ExtendedResourceTypeIndex extendedResourceTypeIndex, boolean showOnlyExecutedMethods, Set<UniformPath> testUniformPaths, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.methodInfoIndex = methodInfoIndex;
        this.crossAnnotator = crossAnnotator;
        this.partitions = partitions;
        this.methodIdIndex = methodIdIndex;
        this.testsToMethodsMapIndex = testsToMethodsMapIndex;
        this.extendedResourceTypeIndex = extendedResourceTypeIndex;
        this.showOnlyExecutedMethods = showOnlyExecutedMethods;
        this.testUniformPaths = testUniformPaths;
        this.codeScopesMappingIndex = codeScopesMappingIndex;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        List<PartitionAndPath> testsWithCoverage = this.testsToMethodsMapIndex.resolveTestsWithCoverage(UniformPathCompatibilityUtil.asUniformPathStringSet(this.testUniformPaths), this.partitions);
        Set<MethodId> methodIdsCoveredByTests = this.testsToMethodsMapIndex.getMethodsCoveredBy(testsWithCoverage).stream().flatMap(Collection::stream).collect(Collectors.toSet());
        List<MethodLocation> methodsCoveredByTest = this.methodIdIndex.getMethodLocations(methodIdsCoveredByTests);
        long testTimestamp = Long.MAX_VALUE;
        if (this.showOnlyExecutedMethods) {
            boolean includeCrossAnnotationInformation = this.crossAnnotator.hasCrossAnnotationIndices();
            Set<AssociatedMethodInfo> methodInfosCoveredByTest = this.methodInfoIndex.getAssociatedMethodInfosForExactPathsAndRegions(methodsCoveredByTest, includeCrossAnnotationInformation);
            return DataRetrieverUtils.createUnassessedTestExecutionData(methodInfosCoveredByTest, methodsCoveredByTest, testTimestamp, this.crossAnnotator, this.extendedResourceTypeIndex, methodInfoFilter, this.codeScopesMappingIndex, this.tgaEnablementPerCodeScope);
        }
        List<AssociatedMethodInfo> allMethodInfos = this.methodInfoIndex.getMethodInfosForPathPrefix((UniformPath)UniformPath.codeRoot());
        return DataRetrieverUtils.createUnassessedTestExecutionData(allMethodInfos, methodsCoveredByTest, testTimestamp, this.crossAnnotator, this.extendedResourceTypeIndex, methodInfoFilter, this.codeScopesMappingIndex, this.tgaEnablementPerCodeScope);
    }
}

