/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.plsql;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.plsql.HProfMethodMappingIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class HProfMethodMappingSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY)
    private MethodInfoIndex previousMethodInfoIndex;
    @DeltaSource(value=MethodInfoIndex.class)
    private IndexDelta<UniformPath> methodInfoDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, name="content")
    private TokenElementIndex previousContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private HProfMethodMappingIndex mappingIndex;
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        List<UniformPath> addedOrChangedPlSqlPaths = HProfMethodMappingSynchronizer.onlyPlSqlPaths((List<UniformPath>)this.methodInfoDelta.getAddedOrChangedKeys(), this.contentIndex);
        List<UniformPath> pathsToDeleteMappingsFor = HProfMethodMappingSynchronizer.onlyPlSqlPaths((List<UniformPath>)this.methodInfoDelta.getDeletedKeys(), this.previousContentIndex);
        pathsToDeleteMappingsFor.addAll(addedOrChangedPlSqlPaths);
        this.removePreviousMappings(pathsToDeleteMappingsFor);
        this.determineAndPersistNewMappings(addedOrChangedPlSqlPaths);
    }

    private void removePreviousMappings(List<UniformPath> pathsToDeleteMappingsFor) throws StorageException {
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (Map.Entry<UniformPath, MethodInfoContainer> pathAndMethods : this.previousMethodInfoIndex.getMethodContainersWithoutCrossAnnotationInfoByUniformPath(pathsToDeleteMappingsFor).entrySet()) {
            MethodInfoContainer container = pathAndMethods.getValue();
            if (container == null) continue;
            TokenElementInfo tokenElementInfo = this.previousContentIndex.getTokenElement(pathAndMethods.getKey());
            for (AssociatedMethodInfo methodInfo : container.getAllMethodInfos(pathAndMethods.getKey())) {
                HProfMethodMappingSynchronizer.createMethodKey(methodInfo, tokenElementInfo).ifPresent(keysToDelete::add);
            }
        }
        this.mappingIndex.removeSourceLocations(keysToDelete);
    }

    private void determineAndPersistNewMappings(List<UniformPath> addedOrChangedPlSqlFiles) throws StorageException {
        PairList values = new PairList();
        for (Map.Entry<UniformPath, MethodInfoContainer> pathAndMethods : this.methodInfoIndex.getMethodContainersWithoutCrossAnnotationInfoByUniformPath(addedOrChangedPlSqlFiles).entrySet()) {
            this.addMappingsForPath(pathAndMethods.getKey(), pathAndMethods.getValue(), (PairList<String, SourceLocation>)values);
        }
        this.mappingIndex.setSourceLocations((PairList<String, SourceLocation>)values);
    }

    private void addMappingsForPath(UniformPath path, MethodInfoContainer methodInfos, PairList<String, SourceLocation> result) throws StorageException {
        TokenElementInfo tokenElementInfo = this.contentIndex.getTokenElement(path);
        LineOffsetConverter offsetConverter = new LineOffsetConverter(tokenElementInfo.getText());
        for (AssociatedMethodInfo methodInfo : methodInfos.getAllMethodInfos(path)) {
            Optional<String> methodKey = HProfMethodMappingSynchronizer.createMethodKey(methodInfo, tokenElementInfo);
            methodKey.ifPresentOrElse(key -> result.add(key, (Object)HProfMethodMappingSynchronizer.getSourceLocation(methodInfo, offsetConverter)), () -> LOGGER.warn(() -> "Package and/or method " + methodInfo.getMethodName() + " not found in file " + String.valueOf(methodInfo.getUniformPath())));
        }
    }

    private static SourceLocation getSourceLocation(AssociatedMethodInfo methodInfo, LineOffsetConverter offsetConverter) {
        String uniformPath = methodInfo.getUniformPath().toStringAsMigrationFrontier();
        OffsetBasedRegion offsetBasedRegion = methodInfo.getAssociatedRegion();
        int startLine = offsetConverter.getLine(offsetBasedRegion.getStart());
        int endLine = offsetConverter.getLine(offsetBasedRegion.getEnd());
        return new SourceLocation(new LineBasedRegion(startLine, endLine), uniformPath);
    }

    private static Optional<String> extractPackageName(AssociatedMethodInfo methodInfo, TokenElementInfo tokenElementInfo) {
        OffsetBasedRegion region = methodInfo.getAssociatedRegion();
        Optional method = ShallowParsingUtils.getMethod(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens(), (OffsetBasedRegion)region);
        return method.map(ShallowEntity::getParent).map(ShallowEntity::getName).map(String::toUpperCase);
    }

    private static Optional<String> createMethodKey(AssociatedMethodInfo methodInfo, TokenElementInfo tokenElementInfo) {
        String procedureName = methodInfo.getMethodName().toUpperCase();
        return HProfMethodMappingSynchronizer.extractPackageName(methodInfo, tokenElementInfo).map(packageName -> packageName + "." + procedureName);
    }

    private static List<UniformPath> onlyPlSqlPaths(List<UniformPath> uniformPaths, TokenElementIndex contentIndex) throws StorageException {
        List isPlSql = CollectionUtils.map(contentIndex.getTokenElementsForPaths(uniformPaths), element -> element.getLanguage() == ELanguage.PLSQL);
        ArrayList<UniformPath> result = new ArrayList<UniformPath>();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            if (!((Boolean)isPlSql.get(i)).booleanValue()) continue;
            result.add(uniformPaths.get(i));
        }
        return result;
    }
}

