/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.google.common.collect.Iterables;
import com.teamscale.index.testgap.MethodLocation;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Index(name="newly-covered-methods", options={EStorageOption.COMPRESSED, EStorageOption.COMMIT_ISOLATED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={MethodLocation.class})
public class NewlyCoveredMethodsIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String INDEX_NAME = "newly-covered-methods";

    public NewlyCoveredMethodsIndex(IStore store) {
        super(store);
    }

    @VisibleForTesting
    void storeMethodsAsNewlyCovered(CommitDescriptor commit, String partition, List<MethodLocation> newlyCoveredMethods, ENewlyCoveredType newlyCoveredType) throws StorageException {
        this.storeMethodsAsNewlyCovered(commit, Collections.singletonMap(partition, newlyCoveredMethods), newlyCoveredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMethodsAsNewlyCovered(CommitDescriptor commit, Map<String, List<MethodLocation>> newlyCoveredMethodsByPartition, ENewlyCoveredType newlyCoveredType) throws StorageException {
        Lock lock = this.store.obtainLock(commit.toString());
        try {
            lock.lock();
            byte[] serializedKey = this.serializeKey(commit, newlyCoveredType);
            SetMap<String, MethodLocation> originalValue = this.deserializeSingleValue(this.store.get(serializedKey));
            for (Map.Entry<String, List<MethodLocation>> entry : newlyCoveredMethodsByPartition.entrySet()) {
                for (MethodLocation location : entry.getValue()) {
                    originalValue.add((Object)entry.getKey(), (Object)location);
                }
            }
            this.store.put(serializedKey, this.serialize(originalValue));
        }
        finally {
            lock.unlock();
        }
    }

    private byte[] serializeKey(CommitDescriptor key, ENewlyCoveredType newlyCoveredType) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{{newlyCoveredType.prefix}, ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(key.getBranchName())), ByteArrayUtils.longToByteArray((long)key.getTimestamp())});
    }

    public @NonNull Set<MethodLocation> getNewlyCoveredMethodLocations(CommitDescriptor commit, List<String> partitions, ENewlyCoveredType newlyCoveredType) throws StorageException {
        SetMap<String, MethodLocation> result = this.deserializeSingleValue(this.store.get(this.serializeKey(commit, newlyCoveredType)));
        HashSet<MethodLocation> locations = new HashSet<MethodLocation>();
        for (String partition : partitions) {
            locations.addAll(result.getCollectionOrEmpty((Object)partition));
        }
        return locations;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public SetMap<CommitDescriptor, MethodLocation> getNewlyCoveredMethodLocations(List<CommitDescriptor> commits, List<String> partitions, ENewlyCoveredType newlyCoveredType) throws StorageException {
        @NonNull List keys = CollectionUtils.mapWithException(commits, commit -> this.serializeKey((CommitDescriptor)commit, newlyCoveredType));
        List<SetMap<String, MethodLocation>> result = this.deserialize(this.store.get(keys));
        SetMap methodsByCommit = new SetMap();
        CollectionUtils.forEachWithException(commits, result, (commit, methods) -> {
            for (String partition : partitions) {
                methodsByCommit.addAll(commit, methods.getCollectionOrEmpty((Object)partition));
            }
        });
        return methodsByCommit;
    }

    public @NonNull Set<UniformPath> getUniformPathsWithNewlyCoveredMethodsInCommits(List<CommitDescriptor> commits, ENewlyCoveredType newlyCoveredType) throws StorageException {
        List keys = CollectionUtils.mapWithException(commits, commit -> this.serializeKey((CommitDescriptor)commit, newlyCoveredType));
        List<SetMap<String, MethodLocation>> result = this.deserialize(this.store.get(keys));
        HashSet<UniformPath> uniformPaths = new HashSet<UniformPath>();
        for (SetMap<String, MethodLocation> entries : result) {
            uniformPaths.addAll(CollectionUtils.map((Collection)entries.getValues(), MethodLocation::getUniformPath));
        }
        return uniformPaths;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        ArrayList toDelete = new ArrayList();
        for (Map.Entry<String, Long> branchAndTimestamp : timestampByBranch.entrySet()) {
            String branch = branchAndTimestamp.getKey();
            long timestamp = branchAndTimestamp.getValue();
            byte[] beginKey = this.serializeKey(new CommitDescriptor(branch, timestamp + 1L), ENewlyCoveredType.EXECUTED);
            byte[] endKey = this.serializeKey(CommitDescriptor.latestOnBranch((String)branch), ENewlyCoveredType.EXECUTED);
            this.store.scanKeys(beginKey, endKey, (IKeyValueCallback)new KeyCollectingCallback(toDelete));
            beginKey = this.serializeKey(new CommitDescriptor(branch, timestamp + 1L), ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
            endKey = this.serializeKey(CommitDescriptor.latestOnBranch((String)branch), ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
            this.store.scanKeys(beginKey, endKey, (IKeyValueCallback)new KeyCollectingCallback(toDelete));
        }
        this.store.remove(toDelete);
    }

    @VisibleForTesting
    List<CommitDescriptor> getAllKeys() throws StorageException {
        final ArrayList<CommitDescriptor> result = new ArrayList<CommitDescriptor>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            final /* synthetic */ NewlyCoveredMethodsIndex this$0;
            {
                NewlyCoveredMethodsIndex newlyCoveredMethodsIndex = this$0;
                Objects.requireNonNull(newlyCoveredMethodsIndex);
                this.this$0 = newlyCoveredMethodsIndex;
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                result.add(this.this$0.deserializeKey(key));
            }
        };
        this.store.scanKeys(new byte[0], (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return result;
    }

    private CommitDescriptor deserializeKey(byte[] serializedKey) throws StorageException {
        return new CommitDescriptor(this.store.getAbbreviator().unabbreviate(ByteArrayUtils.getIntFromByteArray((byte[])serializedKey, (int)1)), ByteArrayUtils.getLongFromByteArray((byte[])serializedKey, (int)5));
    }

    private byte[] serialize(SetMap<String, MethodLocation> partitionToMethodLocations) throws StorageException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SetMap methodLocationToPartitions = partitionToMethodLocations.invert();
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)methodLocationToPartitions.getKeys().size()));
        for (Map.Entry entry : methodLocationToPartitions) {
            MethodLocation methodLocation = (MethodLocation)entry.getKey();
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(methodLocation.getUniformPath().toStringAsMigrationFrontier())));
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)methodLocation.getRegion().getStart()));
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)methodLocation.getRegion().getEnd()));
            Set partitions = (Set)entry.getValue();
            outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)partitions.size()));
            for (String partition : partitions) {
                outputStream.writeBytes(ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(partition)));
            }
        }
        return outputStream.toByteArray();
    }

    private SetMap<String, MethodLocation> deserializeSingleValue(byte[] data) throws StorageException {
        return (SetMap)Iterables.getOnlyElement(this.deserialize(Collections.singletonList(data)));
    }

    private List<SetMap<String, MethodLocation>> deserialize(List<byte[]> dataList) throws StorageException {
        HashSet<Integer> stringIds = new HashSet<Integer>();
        for (byte[] data2 : dataList) {
            if (data2 == null) continue;
            int offset = 0;
            int locationCount = ByteArrayUtils.getIntFromByteArray((byte[])data2, (int)offset);
            offset += 4;
            for (int i = 0; i < locationCount; ++i) {
                stringIds.add(ByteArrayUtils.getIntFromByteArray((byte[])data2, (int)offset));
                int partitionCount = ByteArrayUtils.getIntFromByteArray((byte[])data2, (int)(offset += 12));
                offset += 4;
                for (int b = 0; b < partitionCount; ++b) {
                    stringIds.add(ByteArrayUtils.getIntFromByteArray((byte[])data2, (int)offset));
                    offset += 4;
                }
            }
        }
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        Map unabbreviationMap = abbreviator.buildUnabbreviationMap(stringIds);
        return CollectionUtils.mapWithException(dataList, data -> this.deserializeSingleValueWithLookup((byte[])data, unabbreviationMap));
    }

    private SetMap<String, MethodLocation> deserializeSingleValueWithLookup(byte[] data, Map<Integer, String> unabbreviationMap) {
        SetMap result = new SetMap();
        if (data == null) {
            return result;
        }
        int offset = 0;
        int locationCount = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset);
        offset += 4;
        for (int i = 0; i < locationCount; ++i) {
            MethodLocation methodLocation = new MethodLocation(UniformPath.parse((String)unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset))), new OffsetBasedRegion(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4)), ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 8))));
            int partitionCount = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 12));
            offset += 4;
            for (int b = 0; b < partitionCount; ++b) {
                result.add((Object)unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset)), (Object)methodLocation);
                offset += 4;
            }
        }
        return result;
    }

    public static enum ENewlyCoveredType {
        EXECUTED(0),
        EXECUTED_AFTER_CHANGE(1);

        private final byte prefix;

        private ENewlyCoveredType(byte prefix) {
            this.prefix = prefix;
        }
    }
}

