/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.testimpact.CoverageUnitChangeEntry;
import com.teamscale.index.testimpact.CoverageUnitChangeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class TestDeltaCalculator {
    public static Set<PartitionAndPath> getTestDelta(CommitDescriptor currentCommit, CommitDescriptorIndex commitDescriptorIndex, CoverageUnitChangeIndex testwiseCoverageChangeIndex) throws StorageException, CommitResolutionException {
        List<CommitDescriptor> unmergedCommits = TestDeltaCalculator.getUnmergedCommits(currentCommit, commitDescriptorIndex);
        List testChangeEntries = CollectionUtils.filterNullEntries((Collection)testwiseCoverageChangeIndex.getEntries(unmergedCommits));
        HashSet<PartitionAndPath> changedOrDeletedTests = new HashSet<PartitionAndPath>();
        for (CoverageUnitChangeEntry testChangeEntry : testChangeEntries) {
            changedOrDeletedTests.addAll(testChangeEntry.getChangedTests());
            changedOrDeletedTests.addAll(testChangeEntry.getDeletedTests());
        }
        return changedOrDeletedTests;
    }

    public static List<CommitDescriptor> getUnmergedCommits(CommitDescriptor currentCommit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException, CommitResolutionException {
        ArrayList<CommitDescriptor> unmergedCommits = new ArrayList<CommitDescriptor>();
        ParentedCommitDescriptor parentedCommit = commitDescriptorIndex.getCommit(currentCommit);
        UnmodifiableList parentCommits = parentedCommit.getParentCommits();
        for (int i = 1; i < parentCommits.size(); ++i) {
            unmergedCommits.addAll(TestDeltaCalculator.getCommitsToBeMerged(parentedCommit.getFirstParentCommit(), (CommitDescriptor)parentCommits.get(i), commitDescriptorIndex));
        }
        return unmergedCommits;
    }

    private static List<CommitDescriptor> getCommitsToBeMerged(CommitDescriptor targetCommit, CommitDescriptor sourceCommit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException, CommitResolutionException {
        Optional<MergeBaseInfo> mergeBaseInfo = MergeBaseResolver.computeMergeBaseInfo(sourceCommit, targetCommit, commitDescriptorIndex);
        if (mergeBaseInfo.isPresent()) {
            return CollectionUtils.map(mergeBaseInfo.get().getAncestorsOfSource(), ParentedCommitDescriptor::getCommit);
        }
        return commitDescriptorIndex.getCommitHistory(sourceCommit, 0L);
    }
}

