/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinksIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestElementContentSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=TestLinksIndex.class)
    private KeyDelta keyDeltaTestLinks;
    @DeltaSource(value=TestImplementationIndex.class)
    private KeyDelta keyDeltaTests;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="test-executions-content")
    private TokenElementIndex testContentIndex;
    private List<String> testExecutionsUpdated;
    private List<String> deletedTestExecutions;

    public void execute() throws StorageException {
        this.testExecutionsUpdated = TestElementContentSynchronizer.getTestExecutions(this.keyDeltaTestLinks.getAddedOrChangedKeysAsStrings());
        this.deletedTestExecutions = TestElementContentSynchronizer.getTestExecutions(this.keyDeltaTestLinks.getDeletedKeysAsStrings());
        this.updateContentIndex();
    }

    private static @NonNull List<String> getTestExecutions(List<String> keys) {
        return CollectionUtils.filter(keys, path -> path.startsWith(UniformPath.EType.TEST_EXECUTION.getPrefix() + UniformPathUtils.SEPARATOR));
    }

    private void updateContentIndex() throws StorageException {
        PairList tokenElementInfos = new PairList();
        for (String test : this.keyDeltaTests.getAddedOrChangedKeysAsStrings()) {
            tokenElementInfos.add((Object)test, (Object)TokenElementInfo.createWithLocalPreprocessing(test, ELanguage.TEXT, ""));
        }
        for (String testExecutionPath : this.testExecutionsUpdated) {
            tokenElementInfos.add((Object)testExecutionPath, (Object)TokenElementInfo.createWithLocalPreprocessing(testExecutionPath, ELanguage.TEXT, ""));
        }
        this.testContentIndex.setTokenElements((PairList<String, TokenElementInfo>)tokenElementInfos);
        this.testContentIndex.removeTokenElements(CollectionUtils.unionList((Collection)this.keyDeltaTests.getDeletedKeysAsStrings(), (Collection[])new Collection[]{this.deletedTestExecutions}));
    }
}

