/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testimpact.CoverageUnitChangeEntry;
import com.teamscale.index.testimpact.CoverageUnitChangeIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.index.testimpact.ImpactedTestsIndexUpdater;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMapper;
import com.teamscale.index.testimpact.MethodIdMappingUpdater;
import com.teamscale.index.testimpact.MultipleParentUpdateStrategy;
import com.teamscale.index.testimpact.SingleParentUpdateStrategy;
import com.teamscale.index.testimpact.TestDeltaCalculator;
import com.teamscale.index.testimpact.TestsToMethodsMappingUpdateStrategyBase;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionIndexDelta;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestImpactSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<MethodInfoIndex> parentMethodInfoIndices;
    @DeltaSource(value=MethodInfoIndex.class)
    private IndexDelta<UniformPath> methodInfoIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CoverageUnitToMethodsMapIndex coverageUnitToMethodsMapIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<CoverageUnitToMethodsMapIndex> parentCoverageUnitToMethodsMapIndices;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TestExecutionIndex testExecutionIndex;
    @DeltaSource(value=TestExecutionIndex.class)
    private TestExecutionIndexDelta testExecutionIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExecutionUnitIndex executionUnitIndex;
    @DeltaSource(value=ExecutionUnitIndex.class)
    private TestExecutionIndexDelta executionUnitIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ImpactedTestsIndex impactedTestsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CoverageUnitChangeIndex coverageUnitChangeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodIdIndex methodIdIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<MethodIdIndex> parentMethodIdIndices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws StorageException {
        Set<String> mergedPartitionsOfAllParents = this.getMergedPartitions();
        if (mergedPartitionsOfAllParents.isEmpty() && this.coverageUnitToMethodsMapIndex.getPartitions().isEmpty()) {
            return;
        }
        ImpactedTestsIndexUpdater impactedTestsIndexUpdater = new ImpactedTestsIndexUpdater(this.impactedTestsIndex);
        impactedTestsIndexUpdater.updateTestAndExecutionUnits(this.testExecutionIndex, this.testExecutionIndexDelta, this.executionUnitIndex, this.executionUnitIndexDelta);
        if (!this.methodInfoIndexDelta.isEmpty() && !mergedPartitionsOfAllParents.isEmpty()) {
            this.startProfiling("TestsToMethodsMapping update");
            MethodIdMapper methodIdMapper = new MethodIdMapper(this.methodIdIndex, this.parentMethodIdIndices, this.methodInfoIndex);
            MethodIdMappingUpdater.initMethodIdMapper(methodIdMapper, this.getSchedulingCommit(), this.methodInfoIndexDelta, this.methodInfoIndex, this.parentMethodInfoIndices);
            try {
                this.updateTestsToMethodsMapIndex(methodIdMapper, mergedPartitionsOfAllParents);
            }
            catch (CommitResolutionException e) {
                LOGGER.error("Failed to update {}. Impacted tests will not be updated.", (Object)((Object)((Object)this.coverageUnitToMethodsMapIndex)).getClass().getSimpleName(), (Object)e);
                return;
            }
            finally {
                this.endProfiling("TestsToMethodsMapping update");
            }
            this.startProfiling("ImpactedTestsIndex update");
            impactedTestsIndexUpdater.updateMethodInfos(this.parentCoverageUnitToMethodsMapIndices.getFirst(), this.methodInfoIndexDelta, this.coverageUnitToMethodsMapIndex, methodIdMapper, this.getSchedulingCommit().getTimestamp());
            this.endProfiling("ImpactedTestsIndex update");
        }
    }

    private void updateTestsToMethodsMapIndex(MethodIdMapper methodIdMapper, Set<String> mergedPartitionsOfAllParents) throws StorageException, CommitResolutionException {
        TestsToMethodsMappingUpdateStrategyBase updateStrategy = this.getTestsToMethodsMappingUpdateStrategy(methodIdMapper);
        Set<PartitionAndPath> updatedTests = updateStrategy.calculateUpdateAndStore(this.coverageUnitToMethodsMapIndex);
        this.coverageUnitToMethodsMapIndex.addPartitions(mergedPartitionsOfAllParents);
        methodIdMapper.persist();
        this.storeUpdatedTestsInChangeIndex(updatedTests);
    }

    private void storeUpdatedTestsInChangeIndex(Collection<PartitionAndPath> updatedTests) throws StorageException {
        CoverageUnitChangeEntry testChangeEntry = this.coverageUnitChangeIndex.getExistingOrEmptyEntry(this.getSchedulingCommit());
        testChangeEntry.addChangedTests(updatedTests);
        this.coverageUnitChangeIndex.setEntry(testChangeEntry);
    }

    private String getSectionNameForUpdateStrategy() {
        if (this.parentMethodInfoIndices.size() == 1) {
            return "Single parent";
        }
        return "Multi parent";
    }

    private void startProfiling(String section) {
        this.getProfilingMonitor().startProfiling(this.getSectionNameForUpdateStrategy() + " " + section);
    }

    private void endProfiling(String section) {
        this.getProfilingMonitor().stopProfiling(this.getSectionNameForUpdateStrategy() + " " + section);
    }

    private Set<String> getMergedPartitions() throws StorageException {
        HashSet<String> partitions = new HashSet<String>();
        for (CoverageUnitToMethodsMapIndex testsToMethodsMapIndex : this.parentCoverageUnitToMethodsMapIndices) {
            partitions.addAll(testsToMethodsMapIndex.getPartitions());
        }
        return partitions;
    }

    private TestsToMethodsMappingUpdateStrategyBase getTestsToMethodsMappingUpdateStrategy(MethodIdMapper methodIdUpdateMaps) throws StorageException, CommitResolutionException {
        CoverageUnitChangeEntry coverageUnitChangeEntry = this.coverageUnitChangeIndex.getExistingOrEmptyEntry(this.getSchedulingCommit());
        HashSet updatedCoverageUnits = CollectionUtils.unionSet(coverageUnitChangeEntry.getChangedTests(), (Collection[])new Collection[]{coverageUnitChangeEntry.getDeletedTests()});
        if (this.parentMethodInfoIndices.size() == 1 || EFeatureToggle.DISABLE_COVERAGE_MERGING.isEnabled()) {
            return new SingleParentUpdateStrategy(this.methodInfoIndexDelta, this.parentCoverageUnitToMethodsMapIndices.getFirst(), methodIdUpdateMaps, updatedCoverageUnits);
        }
        this.startProfiling("MergeBase calculation");
        Set<PartitionAndPath> testDelta = TestDeltaCalculator.getTestDelta(this.getSchedulingCommit(), this.commitDescriptorIndex, this.coverageUnitChangeIndex);
        this.removeDeletedCoverageUnits(testDelta);
        this.endProfiling("MergeBase calculation");
        return new MultipleParentUpdateStrategy(this.methodInfoIndexDelta, this.parentCoverageUnitToMethodsMapIndices, methodIdUpdateMaps, updatedCoverageUnits, testDelta);
    }

    private void removeDeletedCoverageUnits(Set<PartitionAndPath> testDelta) throws StorageException {
        List testExecutionDelta = CollectionUtils.filter(testDelta, t -> t.toUniformPath().isTestExecutionPath());
        CollectionUtils.forEach((Iterable)testExecutionDelta, this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(testExecutionDelta), (testExecutionPathAndPartition, testExecution) -> {
            if (testExecution == null) {
                testDelta.remove(testExecutionPathAndPartition);
            }
        });
        List<PartitionAndPath> executionUnitDelta = testDelta.stream().filter(t -> t.toUniformPath().isExecutionUnit()).toList();
        CollectionUtils.forEach(executionUnitDelta, this.executionUnitIndex.getExecutionUnits(executionUnitDelta), (executionUnitPathAndPartition, executionUnit) -> {
            if (executionUnit == null) {
                testDelta.remove(executionUnitPathAndPartition);
            }
        });
    }
}

