/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class TestCaseExtractionUtils {
    public static @NonNull String buildImplementationHash(ShallowEntity shallowEntity) {
        String concatenatedTokens = TokenStreamTextUtils.concatTokenTexts((List)shallowEntity.includedTokens());
        return Hashing.murmur3_128().hashString((CharSequence)concatenatedTokens, StandardCharsets.UTF_8).toString();
    }

    public static @NonNull TextRegionLocation createCommentIncludingLocationForShallowEntity(TokenElementTransformContext context, ShallowEntity rawOrNonRawShallowEntity, TextRegionLocation rawTestLocation, Function<Integer, Integer> toNonRaw) {
        ShallowEntity previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)rawOrNonRawShallowEntity);
        int endCommentSearchOffset = toNonRaw.apply(rawOrNonRawShallowEntity.getStartOffset());
        while (previousEntity != null && TestCaseExtractionUtils.isAnnotationOrDecorator(previousEntity)) {
            endCommentSearchOffset = toNonRaw.apply(previousEntity.getStartOffset());
            previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)previousEntity);
        }
        int commentSearchStartOffset = 0;
        if (previousEntity != null) {
            commentSearchStartOffset = previousEntity.equals(rawOrNonRawShallowEntity.getParent()) ? rawOrNonRawShallowEntity.getParent().getStartOffset() : previousEntity.getEndOffset();
        }
        int startCommentSearchOffset = toNonRaw.apply(commentSearchStartOffset);
        List searchTokens = TokenStreamUtils.getTokensBetween(context.getTokens(), (int)startCommentSearchOffset, (int)endCommentSearchOffset);
        int startOffset = endCommentSearchOffset;
        for (int i = searchTokens.size() - 1; i >= 0; --i) {
            if (((IToken)searchTokens.get(i)).getType() == ETokenType.EOL) continue;
            if (!ETokenType.COMMENTS.contains((Object)((IToken)searchTokens.get(i)).getType())) break;
            startOffset = ((IToken)searchTokens.get(i)).getOffset();
        }
        return context.createLocationWithFilteredStartOffset(startOffset, rawTestLocation);
    }

    private static boolean isAnnotationOrDecorator(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("annotation") || entity.getSubtype().equals("decorator") || entity.getSubtype().equals("attribute annotation"));
    }

    public static Pair<String, TestImplementation> buildTestUniformPathWithTestImplementation(String testName, TokenElementTransformContext context, UniformPath testUniformPath, ShallowEntity nonRawTestEntity) {
        String implementationHash = TestCaseExtractionUtils.buildImplementationHash(nonRawTestEntity);
        TextRegionLocation rawLocation = context.createLocationForNonRawShallowEntity(nonRawTestEntity);
        TextRegionLocation codeLocationWithComment = TestCaseExtractionUtils.createCommentIncludingLocationForShallowEntity(context, nonRawTestEntity, rawLocation, Function.identity());
        TestImplementation testImplementation = new TestImplementation(testName, implementationHash, rawLocation, codeLocationWithComment);
        return Pair.createPair((Object)testUniformPath.toString(), (Object)testImplementation);
    }

    public static UniformPath convertToTestImplementationUniformPath(String tokenElementPath, String ... testNameSegments) {
        Preconditions.checkArgument((!tokenElementPath.startsWith(UniformPath.EType.TEST_IMPLEMENTATION.getPrefix() + UniformPathUtils.SEPARATOR) ? 1 : 0) != 0);
        List escapedSegments = CollectionUtils.map((Object[])testNameSegments, UniformPath::escapeSegment);
        return TestCaseExtractionUtils.convertToTestImplementationUniformPath(tokenElementPath, escapedSegments);
    }

    private static UniformPath convertToTestImplementationUniformPath(String tokenElementPath, List<String> escapedTestSegments) {
        Preconditions.checkArgument((!tokenElementPath.startsWith(UniformPath.EType.TEST_IMPLEMENTATION.getPrefix() + UniformPathUtils.SEPARATOR) ? 1 : 0) != 0);
        return UniformPathCompatibilityUtil.convertRelative((String)tokenElementPath).addSuffix((String[])Iterables.toArray(escapedTestSegments, String.class)).resolveAgainstAbsolutePath((UniformPath)UniformPath.testImplementationRoot());
    }

    private TestCaseExtractionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

