/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.roslyn.data;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.upload.roslyn.data.RoslynMessage;
import java.io.IOException;

public class RoslynMessageDeserializer
extends JsonDeserializer<RoslynMessage> {
    public RoslynMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (node.isTextual()) {
            RoslynMessage message = new RoslynMessage();
            message.setText(node.textValue());
            return message;
        }
        if (node.isObject()) {
            return (RoslynMessage)p.getCodec().treeToValue((TreeNode)node, RoslynMessage.class);
        }
        throw new JsonParseException(p, "Expected string or object for message field, got: " + String.valueOf(node.getNodeType()));
    }
}

