/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.user.EUserActivityPeriods;
import com.teamscale.index.gitbridge.abap.AbapGitImporter;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.usage_data.CommitterDisplayName;
import com.teamscale.index.usage_data.UserCounts;
import com.teamscale.index.user.UserAliasLookup;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class CommitterDataCollector {
    private final UserAliasLookup userAliasLookup;
    private static final Logger LOGGER = LogManager.getLogger();
    private final IndexLayer indexLayer;
    private final GlobalStorageSystem globalStorageSystem;
    private PairList<ProjectInfo, ProjectStorageSystem> projectsAndStorageSystemsCache;
    private static final Set<String> SAP_TECHNICAL_USERS = Set.of("ABAP Importer", "DDIC", "SAP*");

    public CommitterDataCollector(IndexLayer indexLayer) throws StorageException {
        this.indexLayer = indexLayer;
        this.globalStorageSystem = indexLayer.openGlobalStorageSystem();
        this.userAliasLookup = UserAliasLookup.createInstance(this.globalStorageSystem);
    }

    public UserCounts calculateNumberOfCommittersForAllProjects() throws StorageException {
        CommittersPerPeriod info = this.collectCommitterCountInfoByPeriod((Set<String>)CollectionUtils.emptySet());
        return new UserCounts(info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_DAY), info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_WEEK), info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_MONTH), info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_90DAYS), info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_180DAYS), info.getCommitterCountForPeriod(EUserActivityPeriods.LAST_YEAR));
    }

    public List<CommitterDisplayName> collectCommitterNamesForLastNumberOfDays(Set<String> projectIdsToInclude, int numberOfDays) throws StorageException {
        this.updateUserAlias(projectIdsToInclude);
        HashSet<CommitterDisplayName> committers = new HashSet<CommitterDisplayName>();
        ZonedDateTime since = DateTimeUtils.zonedNow().minusDays(numberOfDays);
        this.listProjectsAndStorageSystems(projectIdsToInclude).forEach((projectInfo, storageSystem) -> {
            try {
                RepositoryLogIndex logIndex = (RepositoryLogIndex)storageSystem.openProjectIndex(RepositoryLogIndex.class, null);
                committers.addAll(this.collectAuthors(logIndex, since));
            }
            catch (StorageException e) {
                LOGGER.error("Could not determine developer count for project {}. Skipping!", (Object)projectInfo.getInternalId(), (Object)e);
            }
        });
        return new ArrayList<CommitterDisplayName>(CommitterDataCollector.deduplicateCommitters(committers));
    }

    private static Set<CommitterDisplayName> deduplicateCommitters(Set<CommitterDisplayName> committers) {
        List<List<CommitterDisplayName>> committersWithMatchingIdentifiers = CommitterDataCollector.groupCommittersWithMatchingIdentifiers(committers);
        ArrayList<CommitterDisplayName> deduplicatedCommitters = new ArrayList<CommitterDisplayName>();
        for (List<CommitterDisplayName> committersWithSameIdentifier : committersWithMatchingIdentifiers) {
            CommitterDisplayName committerDisplayName = CommitterDataCollector.mergeCommitters(committersWithSameIdentifier);
            deduplicatedCommitters.add(committerDisplayName);
        }
        return new HashSet<CommitterDisplayName>(deduplicatedCommitters);
    }

    private static List<List<CommitterDisplayName>> groupCommittersWithMatchingIdentifiers(Collection<CommitterDisplayName> committers) {
        ListMap<String, CommitterDisplayName> idToCommitters = CommitterDataCollector.groupByIdentifier(committers);
        ArrayList<List<CommitterDisplayName>> result = new ArrayList<List<CommitterDisplayName>>();
        HashSet visited = HashSet.newHashSet(committers.size());
        ArrayDeque<CommitterDisplayName> stack = new ArrayDeque<CommitterDisplayName>();
        for (CommitterDisplayName start : committers) {
            if (!visited.add(start)) continue;
            ArrayList<CommitterDisplayName> committersWithMatchingIdentifier = new ArrayList<CommitterDisplayName>();
            stack.push(start);
            while (!stack.isEmpty()) {
                CommitterDisplayName current = (CommitterDisplayName)stack.pop();
                committersWithMatchingIdentifier.add(current);
                for (String id : current.getIdentifiers()) {
                    List peers = (List)idToCommitters.getCollectionOrEmpty((Object)id);
                    idToCommitters.removeCollection((Object)id);
                    for (CommitterDisplayName peer : peers) {
                        if (!visited.add(peer)) continue;
                        stack.push(peer);
                    }
                }
            }
            result.add(committersWithMatchingIdentifier);
        }
        return result;
    }

    private static ListMap<String, CommitterDisplayName> groupByIdentifier(Collection<CommitterDisplayName> committers) {
        ListMap idToCommitters = new ListMap();
        for (CommitterDisplayName committer : committers) {
            idToCommitters.addAll(committer.getIdentifierMap());
        }
        return idToCommitters;
    }

    private static CommitterDisplayName mergeCommitters(Collection<CommitterDisplayName> committers) {
        if (committers.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge committers");
        }
        Set<String> aliases = committers.stream().map(CommitterDisplayName::getAliases).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> mailAddresses = committers.stream().map(CommitterDisplayName::getEmailAddresses).flatMap(Collection::stream).collect(Collectors.toSet());
        CommitterDisplayName anyCommitter = (CommitterDisplayName)CollectionUtils.getAny(committers);
        CCSMAssert.isNotNull((Object)anyCommitter);
        return new CommitterDisplayName(anyCommitter.getUsername(), anyCommitter.getFullname(), aliases, mailAddresses);
    }

    private static boolean isNonEmptyCodeCommit(RepositoryLogEntryAggregate entry) {
        return !entry.isEmpty() && entry.getCommitTypes() != null && entry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT);
    }

    private static boolean isNoSapCommitFromDifferentSourceSystem(RepositoryLogEntryAggregate entry) {
        String commitMessage = entry.getMessage();
        return commitMessage == null || !AbapGitImporter.DIFFERENT_SOURCE_SYSTEM_PATTERN.matcher(commitMessage).matches();
    }

    private CommitterDisplayName resolveCommitterDisplayName(IRepositoryLogEntry logEntry) {
        return this.userAliasLookup.resolveAuthorOf(logEntry).map(user -> new CommitterDisplayName(user.getUsername(), user.getFullName(), (Set<String>)user.getAliases(), CommitterDataCollector.getEmailAddresses(logEntry.getEmail()))).orElse(new CommitterDisplayName("", "", Set.of(logEntry.getAuthor()), CommitterDataCollector.getEmailAddresses(logEntry.getEmail())));
    }

    private static Set<String> getEmailAddresses(@Nullable String email) {
        if (StringUtils.isEmpty((String)email)) {
            return Collections.emptySet();
        }
        return Set.of(email);
    }

    private Set<CommitterDisplayName> collectAuthors(RepositoryLogIndex index, ZonedDateTime since) throws StorageException {
        long timestampInMilliseconds = since.toInstant().toEpochMilli();
        return index.getEntries(timestampInMilliseconds, Long.MAX_VALUE).stream().filter(CommitterDataCollector::isNonEmptyCodeCommit).filter(logEntry -> !logEntry.getPrimaryEntry().isSourceLibraryChangeCommit()).filter(CommitterDataCollector::isNoSapCommitFromDifferentSourceSystem).filter(logEntry -> !CommitterDataCollector.isTechnicalUser(logEntry.getAuthor())).map(this::resolveCommitterDisplayName).collect(Collectors.toSet());
    }

    private static boolean isTechnicalUser(String author) {
        return "Teamscale import".equals(author) || SAP_TECHNICAL_USERS.contains(author) || author.toLowerCase().contains("dependabot");
    }

    private CommittersPerPeriod collectCommitterCountInfoByPeriod(Set<String> projectIdsToInclude) throws StorageException {
        this.updateUserAlias(projectIdsToInclude);
        CommittersPerPeriod authorCollection = new CommittersPerPeriod(this);
        this.listProjectsAndStorageSystems(projectIdsToInclude).forEach((projectInfo, storageSystem) -> {
            try {
                RepositoryLogIndex logIndex = (RepositoryLogIndex)storageSystem.openProjectIndex(RepositoryLogIndex.class, null);
                authorCollection.collectCommittersByPeriod(logIndex);
            }
            catch (StorageException e) {
                LOGGER.error("Could not determine developer count for project {}. Skipping!", (Object)projectInfo.getInternalId(), (Object)e);
            }
        });
        authorCollection.committersByPeriod.replaceAll((k, v) -> CommitterDataCollector.deduplicateCommitters(v));
        return authorCollection;
    }

    private void updateUserAlias(Set<String> projectIdsToInclude) throws StorageException {
        this.listProjectsAndStorageSystems(projectIdsToInclude).forEach((projectInfo, storageSystem) -> {
            try {
                RepositoryLogIndex logIndex = (RepositoryLogIndex)storageSystem.openProjectIndex(RepositoryLogIndex.class, null);
                ZonedDateTime now = DateTimeUtils.zonedNow();
                this.updateUserAlias(logIndex, now.minusYears(1L).toInstant().toEpochMilli());
            }
            catch (StorageException e) {
                LOGGER.error("Could not determine developer count for project {}. Skipping!", (Object)projectInfo.getInternalId(), (Object)e);
            }
        });
    }

    private void updateUserAlias(RepositoryLogIndex index, long time) throws StorageException {
        index.getEntries(time, Long.MAX_VALUE).stream().filter(CommitterDataCollector::isNonEmptyCodeCommit).filter(logEntry -> !CommitterDataCollector.isTechnicalUser(logEntry.getAuthor())).forEach(logEntry -> this.userAliasLookup.resolveUser(logEntry.getEmail()).ifPresent(user -> user.addAliases(new String[]{logEntry.getAuthor()})));
    }

    private PairList<ProjectInfo, ProjectStorageSystem> listProjectsAndStorageSystems(Set<String> projectIdsToInclude) throws StorageException {
        if (this.projectsAndStorageSystemsCache == null) {
            this.projectsAndStorageSystemsCache = new PairList();
            for (ProjectInfo projectInfo : ((ProjectIndex)this.globalStorageSystem.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
                if (projectInfo.isDeletingOrReanalyzing()) continue;
                this.projectsAndStorageSystemsCache.add((Object)projectInfo, (Object)this.indexLayer.openProjectStorageSystem(projectInfo));
            }
        }
        if (projectIdsToInclude.isEmpty()) {
            return this.projectsAndStorageSystemsCache;
        }
        return (PairList)this.projectsAndStorageSystemsCache.stream().filter(projectAndStorage -> projectIdsToInclude.contains(((ProjectInfo)projectAndStorage.getFirst()).getPrimaryPublicId().toString())).collect(PairList.toPairList());
    }

    private class CommittersPerPeriod {
        private final Map<EUserActivityPeriods, Set<CommitterDisplayName>> committersByPeriod;
        final /* synthetic */ CommitterDataCollector this$0;

        private CommittersPerPeriod(CommitterDataCollector committerDataCollector) {
            CommitterDataCollector committerDataCollector2 = committerDataCollector;
            Objects.requireNonNull(committerDataCollector2);
            this.this$0 = committerDataCollector2;
            this.committersByPeriod = new HashMap<EUserActivityPeriods, Set<CommitterDisplayName>>();
        }

        private void collectCommittersByPeriod(RepositoryLogIndex logIndex) throws StorageException {
            ZonedDateTime now = DateTimeUtils.zonedNow();
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_DAY, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusDays(1L)));
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_WEEK, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusDays(7L)));
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_MONTH, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusMonths(1L)));
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_90DAYS, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusDays(90L)));
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_180DAYS, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusDays(180L)));
            this.committersByPeriod.computeIfAbsent(EUserActivityPeriods.LAST_YEAR, periods -> new HashSet()).addAll(this.this$0.collectAuthors(logIndex, now.minusYears(1L)));
        }

        private Set<CommitterDisplayName> getCommittersByPeriod(EUserActivityPeriods period) {
            return this.committersByPeriod.getOrDefault(period, Collections.emptySet());
        }

        private int getCommitterCountForPeriod(EUserActivityPeriods period) {
            return this.getCommittersByPeriod(period).size();
        }
    }
}

