/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.connection.auth.HelpGenerateUserTokenResponse;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;

@Named
@Singleton
public class AwaitingUserTokenFutureRepository {
    private final ConcurrentHashMap<String, CompletableFuture<HelpGenerateUserTokenResponse>> awaitingFuturesByServerUrl = new ConcurrentHashMap();

    public void addExpectedResponse(String serverBaseUrl, CompletableFuture<HelpGenerateUserTokenResponse> futureResponse) {
        CompletableFuture<HelpGenerateUserTokenResponse> previousFuture = this.awaitingFuturesByServerUrl.put(serverBaseUrl, futureResponse);
        if (previousFuture != null) {
            previousFuture.cancel(false);
        }
    }

    public Optional<CompletableFuture<HelpGenerateUserTokenResponse>> consumeFutureResponse(String serverOrigin) {
        Iterator<Map.Entry<String, CompletableFuture<HelpGenerateUserTokenResponse>>> iterator = this.awaitingFuturesByServerUrl.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CompletableFuture<HelpGenerateUserTokenResponse>> entry = iterator.next();
            if (!ConnectionConfigurationRepository.haveSameOrigin(entry.getKey(), serverOrigin)) continue;
            iterator.remove();
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }
}

