/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.repository.rules;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.event.ConnectionConfigurationRemovedEvent;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;
import org.sonarsource.sonarlint.core.rules.RulesExtractionHelper;

@Named
@Singleton
public class RulesRepository {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final RulesExtractionHelper extractionHelper;
    private Map<String, SonarLintRuleDefinition> embeddedRulesByKey;
    private final Map<String, Map<String, SonarLintRuleDefinition>> rulesByKeyByConnectionId = new HashMap<String, Map<String, SonarLintRuleDefinition>>();
    private final Map<String, Map<String, String>> ruleKeyReplacementsByConnectionId = new HashMap<String, Map<String, String>>();

    public RulesRepository(RulesExtractionHelper extractionHelper) {
        this.extractionHelper = extractionHelper;
    }

    public Collection<SonarLintRuleDefinition> getEmbeddedRules() {
        this.lazyInit();
        return this.embeddedRulesByKey.values();
    }

    public Optional<SonarLintRuleDefinition> getEmbeddedRule(String ruleKey) {
        this.lazyInit();
        return Optional.ofNullable(this.embeddedRulesByKey.get(ruleKey));
    }

    private synchronized void lazyInit() {
        if (this.embeddedRulesByKey == null) {
            this.embeddedRulesByKey = RulesRepository.byKey(this.extractionHelper.extractEmbeddedRules());
        }
    }

    public Collection<SonarLintRuleDefinition> getRules(String connectionId) {
        this.lazyInit(connectionId);
        return this.rulesByKeyByConnectionId.getOrDefault(connectionId, Map.of()).values();
    }

    public Optional<SonarLintRuleDefinition> getRule(String connectionId, String ruleKey) {
        this.lazyInit(connectionId);
        Map<String, SonarLintRuleDefinition> connectionRules = this.rulesByKeyByConnectionId.get(connectionId);
        return Optional.ofNullable(connectionRules.get(ruleKey)).or(() -> Optional.ofNullable((SonarLintRuleDefinition)connectionRules.get(this.ruleKeyReplacementsByConnectionId.get(connectionId).get(ruleKey))));
    }

    private synchronized void lazyInit(String connectionId) {
        Map<String, SonarLintRuleDefinition> rulesByKey = this.rulesByKeyByConnectionId.get(connectionId);
        if (rulesByKey == null) {
            this.setRules(connectionId, this.extractionHelper.extractRulesForConnection(connectionId));
        }
    }

    private void setRules(String connectionId, Collection<SonarLintRuleDefinition> rules) {
        Map<String, SonarLintRuleDefinition> rulesByKey = RulesRepository.byKey(rules);
        HashMap ruleKeyReplacements = new HashMap();
        rules.forEach(rule -> rule.getDeprecatedKeys().forEach(deprecatedKey -> ruleKeyReplacements.put(deprecatedKey, rule.getKey())));
        this.rulesByKeyByConnectionId.put(connectionId, rulesByKey);
        this.ruleKeyReplacementsByConnectionId.put(connectionId, ruleKeyReplacements);
    }

    private static Map<String, SonarLintRuleDefinition> byKey(Collection<SonarLintRuleDefinition> rules) {
        return rules.stream().collect(Collectors.toMap(SonarLintRuleDefinition::getKey, r -> r));
    }

    @Subscribe
    public void connectionRemoved(ConnectionConfigurationRemovedEvent e) {
        this.evictAll(e.getRemovedConnectionId());
    }

    private void evictAll(String connectionId) {
        this.logger.debug("Evict cached rules definitions for connection '{}'", (Object)connectionId);
        this.rulesByKeyByConnectionId.remove(connectionId);
        this.ruleKeyReplacementsByConnectionId.remove(connectionId);
    }
}

