/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.IssueStorePaths;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;

public class IssueStoreReader {
    private final ConnectionStorage storage;

    public IssueStoreReader(ConnectionStorage storage) {
        this.storage = storage;
    }

    public List<ServerIssue> getServerIssues(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        String sqPath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (sqPath == null) {
            return Collections.emptyList();
        }
        List<ServerIssue> loadedIssues = this.storage.project(projectBinding.projectKey()).findings().load(branchName, sqPath);
        loadedIssues.forEach(issue -> issue.setFilePath(ideFilePath));
        return loadedIssues;
    }

    public List<ServerTaintIssue> getServerTaintIssues(ProjectBinding projectBinding, String branchName, String ideFilePath, boolean includeResolved) {
        String sqPath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (sqPath == null) {
            return Collections.emptyList();
        }
        List<ServerTaintIssue> loadedIssues = this.storage.project(projectBinding.projectKey()).findings().loadTaint(branchName, sqPath);
        if (!includeResolved) {
            loadedIssues = IssueStoreReader.filterOutResolvedIssues(loadedIssues);
        }
        loadedIssues.forEach(issue -> issue.setFilePath(ideFilePath));
        return loadedIssues;
    }

    public List<ServerTaintIssue> getRawServerTaintIssues(ProjectBinding projectBinding, String branchName) {
        List<ServerTaintIssue> loadedIssues = this.storage.project(projectBinding.projectKey()).findings().loadTaint(branchName);
        return IssueStoreReader.filterOutResolvedIssues(loadedIssues);
    }

    public Collection<ServerHotspot> getServerHotspots(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        String serverFilePath = IssueStorePaths.idePathToServerPath(projectBinding, ideFilePath);
        if (serverFilePath == null) {
            return Collections.emptyList();
        }
        Collection<ServerHotspot> loadedHotspots = this.storage.project(projectBinding.projectKey()).findings().loadHotspots(branchName, serverFilePath);
        loadedHotspots.forEach(hotspot -> hotspot.setFilePath(ideFilePath));
        return loadedHotspots;
    }

    @NotNull
    private static List<ServerTaintIssue> filterOutResolvedIssues(List<ServerTaintIssue> loadedIssues) {
        return loadedIssues.stream().filter(Predicate.not(ServerTaintIssue::isResolved)).collect(Collectors.toList());
    }
}

